% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td_sim.R
\name{td_sim}
\alias{td_sim}
\title{Simulation of a diversity-dependent-like time-dependent process}
\usage{
td_sim(pars, age, ddmodel = 1, methode = "ode45")
}
\arguments{
\item{pars}{Vector of parameters:
\cr \cr \code{pars[1]} corresponds to
lambda0 (speciation rate)
\cr \code{pars[2]} corresponds to mu0 (extinction
rate)
\cr \code{pars[3]} corresponds to lambda1 (decline parameter in
speciation rate) or K in diversity-dependence-like models
\cr \code{pars[4]} corresponds to mu1 (decline parameter in extinction rate)}

\item{age}{crown age of the tree to simulate, i.e. the simulation time.}

\item{ddmodel}{the diversity-dependent model used as reference for the 
time-dependent model.}

\item{methode}{The method used to solve the master equation. 
See \code{deSolve::ode()} documentation for possible inputs}
}
\value{
A list with the following four elements: The first element is the 
tree of extant species in phylo format \cr
The second element is the tree of all species, including extinct species, 
in phylo format \cr
The third element is a matrix of all species where 
- the first column is the time at which a species is born \cr
- the second column is the label of the parent of the species; 
positive and negative values only indicate whether the species belongs to 
the left or right crown lineage \cr
- the third column is the label of the daughter species itself; 
positive and negative values only indicate whether the species belongs to 
the left or right crown lineage \cr
- the fourth column is the time of extinction of the species. If this 
equals -1, then the species is still extant.
}
\description{
Simulates a phylogenetic tree branching according to a 
time-dependent process calibrated on the expected number 
of species under a diversity-dependent process over time.
}
\author{
César Martinez, Rampal S. Etienne
}
