% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEEVD.R
\name{Weibull}
\alias{Weibull}
\title{Estimated Density Values by Weibull kernel}
\usage{
Weibull(y, k, h)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}
}
\value{
\item{x}{grid points}
        \item{y}{estimated values of density}
}
\description{
Estimated Kernel density values by using Weibull Kernel.
}
\details{
The Weibull kernel is developed by Salha et al. (2014). They used it to nonparametric estimation of the probability density function (pdf) and the hazard rate function for independent and identically distributed (iid) data.
Weibull Kernel is
\deqn{ K_w\left( x, \frac{1}{h}\right)(t) =\frac{\Gamma(1+h)}{hx}\left[ \frac{t\Gamma(1+h)}{x}\right] ^{\frac{1}{h}-1} exp\left( -\left( \frac{t\Gamma(1+h)}{x}\right) ^\frac{1}{h}\right)}
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
Weibull(y,200,h)
}
\references{
Salha, R. B., El Shekh Ahmed, H. I., & Alhoubi, I. M. 2014. Hazard Rate Function Estimation Using Weibull Kernel. \emph{Open Journal of Statistics} \strong{4} (08), 650-661.
}
\seealso{
For esitimated values by Gumbel kernel see \code{\link{Gumbel}}. Further, for plot and MSE by Weibull kernel see \code{\link{plot.Weibull}} and \code{\link{mseweibull}}, respectively.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
