% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{de_heat}
\alias{de_heat}
\title{Create heat maps of differentially expressed genes.}
\usage{
de_heat(res_list, filename = "heatmap.pdf", anno_columns,
  sort_choice = "none", specific_genes = "", numGenes = 30,
  theme = 2, cluster_genes = TRUE, cluster_contrasts = TRUE,
  customLabels = FALSE, returnData = FALSE)
}
\arguments{
\item{res_list}{A list of DESeq result sets. Results can be calculated individually using DESeq's results() function.
Lists of results can be created by creating a list(result1, result2 ... result_N).}

\item{filename}{Filename for output plot.  Valid extensions are ".pdf" and ".png".
File generation can be turned off using set_output_mode("screen"). Output will be written to the /DE/heatmaps/ directory.}

\item{anno_columns}{Annotation column names as a single string or a concatenated list of strings. Must correspond
to columns in the targets metadata file. Multiple columns are allowed.  I.E. c("Condition", "Timepoint")}

\item{sort_choice}{Sorting method for DE genes. Possible options are: "mean", "max", "min", "variance", "max_mean","min_mean", "sd".
"max" sorts genes based on the highest expression level of any single gene in a result set.
In contrast, "max_mean" first calculates mean expression across all result sets and subsequently sorts by maximum values.
Min and min_mean function similarly.  Variance and sd sort genes by highest gene-wise variance or standard deviation.}

\item{specific_genes}{A character vector of gene names can be passed to this parameter to plot the genes specified. This overrides sorting
and numGene parameters.}

\item{numGenes}{Number of genes to include in the plot. Default: 30}

\item{theme}{Theme for the layout and color scheme for the plot.  Valid selections are integers between 1-6.}

\item{cluster_genes}{Boolean.  Cluster genes (rows) of the heat map.  Default: TRUE}

\item{cluster_contrasts}{Boolean.  Cluster contrasts (columns) of the heat map.  Default: TRUE}

\item{customLabels}{If customLabels is set to TRUE, the user will be prompted to provide a custom label for each label on the x-axis.}

\item{returnData}{Boolean.  Determines if this visualization should return data used to generate the visualization. Default=FALSE.}
}
\value{
If returnData is true, this function will return a data frame containing expression data for the genes visualized in
the heat map based on the sorting method and numGenes parameters.
}
\description{
This function generates heat maps for differentially expressed gene result sets based on the experimental design.
Sorting and filtration can be applied to visualize genes based on specific criteria, and additional annotation
can be included in the heat map based on target metadata columns.
For example, aggregated results from several contrasts can have their differentially expressed genes sorted based on
a specific metric, and the top N genes can be plotted based on that sorting method.
}
\examples{
\dontrun{

#Prepare a result list for aggregation.
res.day1 <- results(dds, contrast=c("Condition_Time", "day1_disease", "day1_control"))
res.day2 <- results(dds, contrast=c("Condition_Time", "day2_disease", "day2_control"))
res.day3 <- results(dds, contrast=c("Condition_Time", "day3_disease", "day3_control"))
myResList <- list(res.day1, res.day2, res.day3)

/*
 * Create a heat map of the top 25 most upregulated genes based on time and condition.
 * Gene-wise max value based calculation.
 */
de_heat(res_list=myResList, anno_columns=c("Time", "Condition"), sort_choice="max",
         numGenes=25, theme=2, returnData=FALSE)


/*
 * Create a heat map of the top 50 most downregulated genes based on time and condition.
 * Mean based value calculation.
 */
de_heat(res_list=myResList, anno_columns=c("Time", "Condition"), sort_choice="min_mean",
         numGenes=50, theme=2, returnData=FALSE)


/*
 * Create a heat map of the top 100 most highly varying genes based on time and response.
 * Variance based value calculation.
 */
de_heat(res_list=myResList, anno_columns=c("Time", "Response"), sort_choice="variance",
         numGenes=100, theme=2, returnData=FALSE)

/*
 * Plot 3 specific genes, dont cluster by contrast.
 */
de_heat(res_list=myResList, anno_columns=c("Time", "Response"), sort_choice="variance",
        specific_genes=c("GEN1", "ABC2", "FuSG2"), theme=2, cluster_contrasts=FALSE)

}
}
\keyword{filter}
\keyword{heatmap}
\keyword{sort}
\keyword{visualization}
