% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{computeObsWSAF}
\alias{computeObsWSAF}
\title{Compute observed WSAF}
\usage{
computeObsWSAF(alt, ref)
}
\arguments{
\item{alt}{Numeric array of alternative allele count.}

\item{ref}{Numeric array of reference allele count.}
}
\value{
Numeric array of observed allele frequency within sample.
}
\description{
Compute observed allele frequency within sample from the allele
 counts.
}
\examples{
# Example 1
refFile = system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile = system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageT = extractCoverageFromTxt(refFile, altFile)
obsWSAF = computeObsWSAF(PG0390CoverageT$altCount, PG0390CoverageT$refCount)

# Example 2
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV = extractCoverageFromVcf(vcfFile)
obsWSAF = computeObsWSAF(PG0390CoverageV$altCount, PG0390CoverageV$refCount)

}
\seealso{
\code{\link{histWSAF}} for histogram.
}
