% Generated by roxygen2 (4.0.1): do not edit by hand
\name{UnsignedArea}
\alias{UnsignedArea}
\title{Calculates Raju's Unsigned Area Measure index for an item with given item parameters of focal and reference groups.}
\usage{
UnsignedArea(itemParameters, irtModel = "2pl", subdivisions = 5000,
  logistic = TRUE)
}
\arguments{
\item{itemParameters}{A list containing "focal" and "reference" item parameters. Item parameters are assumed to be on the same scale. Item parameters for each group should me a matrix with nrow equal to the number of items.}

\item{irtModel}{A string stating the irtModel to be used. Should be one of "1pl", "2pl", "3pl", "grm" or "pcm".}

\item{subdivisions}{A numeric value indicating the number of subdivisions for numerical integration.}

\item{logistic}{A logical value stating if the IRT model will use the logistic or the normal metric. Defaults to using the logistic metric by fixing the D constant to 1. If FALSE the constant is set to 1.702 so that the normal metric is used.}
}
\value{
uam A numeric matrix with the Unsigned Area Measure values for all the item parameter in each set of itemParameterList
}
\description{
Calculates Raju's Unsigned Area Measure index for an item with given item parameters of focal and reference groups.
}
\examples{
data(dichotomousItemParameters)
uam3pl <- UnsignedArea(itemParameters = dichotomousItemParameters, irtModel = "3pl",
                       subdivisions = 5000, logistic = TRUE)
}
\author{
Victor H. Cervantes <vcervantes at icfes.gov.co> <vhcervantesb at unal.edu.co>
}
\references{
Cohen, A., Kim, S-H and Baker , F. (1993). Detection of differential item functioning in the Graded Response Moodel. Applied psychological measurement, 17(4), 335-350

Raju, N. (1988). The area between two item characteristic cureves. Psychometricka, 53(4), 495--502.
}

