% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPower.R
\name{runPower}
\alias{runPower}
\title{Run a power analysis on counts and design matrix}
\usage{
runPower(
  countsMatrix,
  designMatrix,
  depth = c(10, 100, 1000),
  N = c(3, 6, 10, 20),
  FDR = c(0.05, 0.1),
  effectSize = c(1.2, 1.5, 2),
  includePlots = FALSE
)
}
\arguments{
\item{countsMatrix}{A counts matrix or dataframe of numeric data. (Required)}

\item{designMatrix}{A design matrix or dataframe of numeric data. (Required)}

\item{depth}{A set of depth to use in the calculations.  The default depths of
c(10, 100, 1000) respectively represent a detection limit, below average
expression, and median expression levels, expressed in read count units.}

\item{N}{A set of N value to report power for. (Default = c(3, 6, 10, 20))}

\item{FDR}{FDR thresholds to filter for for FDR vs. Power graph. (Default = c(0.05, 0.1))}

\item{effectSize}{A set of fold change values to test. (Default = c(1.2, 1.5, 2))}

\item{includePlots}{controls adding tow plots to the returned dataframe (Default = FALSE).
The two plots are; a ROC curve (FDR vs. Power) and a plot of N vs. Power.
Possible values to pass:
\itemize{
  \item \strong{FALSE or NULL}: Disable plots
  \item \strong{TRUE or "canvasXpress"}: returns "canvasXpress" plots.
  \item \strong{"ggplot"}: returns "ggplot" plots.}}
}
\value{
a dataframe of power calculations or a list of the dataframe and defined plots as defined by the "includePlots" argument.
}
\description{
Take a counts matrix and design matrix and return a power analysis using
the RNASeqPower package. The counts matrix should be pre-filtered to remove
non-expressed genes using an appropriate filtering criteria. The design matrix
should describe the major sources of variation so the procedure can dial
out those known effects for the power calculations.
}
\details{
Note, both 'RNASeqPower' and 'statmod' packages are required to run this function as follow:
\itemize{
\item {'RNASeqPower' package is required to run power analysis on the given counts matrix and design matrix.}
\item {'statmod' package is required to run estimate dispersion calculations}
}

If includePlots = FALSE (the default) or NULL, the function will return a tall skinny dataframe
of power calculations for various requested combinations of N and significance
thresholds.

If includePlots = TRUE, "canvasXpress" or "ggplot", a list is returned with an additional two
"canvasXpress" or ggplots (plots) to the dataframe.
}
\examples{
if (requireNamespace("RNASeqPower", quietly = TRUE) &&
    requireNamespace("statmod", quietly = TRUE)) {

    dgeObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))
    counts <- dgeObj$counts
    dm     <- DGEobj::getType(dgeObj, type = "designMatrix")[[1]]

    resultList <- runPower(countsMatrix = counts,
                           designMatrix = dm,
                           includePlots = TRUE)

    head(resultList[[1]]) # dataframe
    resultList[[2]]       # ROC Curves Plot
    resultList[[3]]       # N vs Power Plot
}

}
