% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{getAttribute}
\alias{getAttribute}
\title{Get a specified attribute}
\usage{
getAttribute(dgeObj, attrName)
}
\arguments{
\item{dgeObj}{A DGEobj}

\item{attrName}{Name of the attribute to retrieve}
}
\value{
The specified attribute value or NULL if the attribute doesn't exist
}
\description{
Get a specified attribute
}
\examples{
    # example DGEobj
    exObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    # Get an attribute from a DGEobj
    getAttribute(exObj, "type")

    # Get an attribute from a DGEobj item
    getAttribute(exObj$designMatrix, "formula")

}
