% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm.R
\name{node}
\alias{node}
\title{Runs exhaustive search on a single node and saves results in txt file.}
\usage{
node(
  X,
  n,
  id = NULL,
  nbf = 15,
  delta = seq(0.5, 1, 0.01),
  cpp = TRUE,
  priors = priors.spec(),
  path = getwd(),
  method = "exhaustive"
)
}
\arguments{
\item{X}{array with dimensions timeseries x nodes.}

\item{n}{node number.}

\item{id}{subject ID. If set, results are saved to a txt file.}

\item{nbf}{Log Predictive Likelihood will sum from (and including) this time point.}

\item{delta}{a vector of potential values for the discount factor.#'}

\item{cpp}{boolean true (default): fast C++ implementation, false: native R code.}

\item{priors}{list with prior hyperparameters.}

\item{path}{a path where results are written.}

\item{method}{can be exhaustive (default), forward, backward, or both.}
}
\value{
store list with results.
}
\description{
Runs exhaustive search on a single node and saves results in txt file.
}
