% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chmortp.R
\name{chmortp}
\alias{chmortp}
\title{Calculates the childhood component death probabilities based on survey data.}
\usage{
chmortp(
  Data.Name,
  Weight = NULL,
  Date_of_interview = NULL,
  Date_of_birth = NULL,
  Age_at_death = NULL,
  PeriodEnd = NULL,
  Period = NULL,
  Class = NULL
)
}
\arguments{
\item{Data.Name}{The DHS births (BR) dataset or data from other survey with the same format.}

\item{Weight}{Survey weight variable if other than "v005".}

\item{Date_of_interview}{Date of Interview (CMC) variable if other than "v008".}

\item{Date_of_birth}{Child date of birth (CMC) variable if other than "b3".}

\item{Age_at_death}{Child age at death (in months) variable if other than "b7".}

\item{PeriodEnd}{The end of the exposure period in YYYY-MM format; default is the date of the survey.}

\item{Period}{The study period for mortality in months; default is 60 months (5 years).}

\item{Class}{Allow for domain level indicators.}
}
\value{
Childhood component death probabilities.
}
\description{
\code{chmortp} returns weighted childhood component death probabilities for 8 age segments 0, 1-2, 3-5, 6-11,
12-23, 24-35, 36-47, and 48-59 months
\code{chmort} returns weighted and unweighted  number of deaths and children-years exposure.
}
\examples{
# Calculate childhood component death probabilities based on ADBR70 data

data("ADBR70")
chmortp(
 ADBR70
)

}
\author{
Mahmoud Elkasabi.
}
