% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/DIFtree.R
\name{DIFtree}
\alias{DIFtree}
\alias{print.DIFtree}
\alias{summary.DIFtree}
\title{Item Focused Trees for the Identification of Items in Differential Item Functioning}
\usage{
DIFtree(Y, X, alpha, nperm, trace = FALSE, penalize = FALSE)

\method{print}{DIFtree}(x, ...)

\method{summary}{DIFtree}(object, ...)
}
\arguments{
\item{Y}{Matrix or Data.frame of binary 0/1 response (rows correspond to persons, columns correspond to items)}

\item{X}{Data.frame of (not scaled) covariates (rows correspond to persons, columns correspond to covariates)}

\item{alpha}{global significance level for the permutation tests}

\item{nperm}{number of permutations for the permutation tests}

\item{trace}{If true, information about the estimation progress is printed}

\item{penalize}{If true, a small ridge penalty is added to ensure existence of model parameters}

\item{x,object}{Object of class \code{"DIFtree"}}

\item{...}{further arguments passed to or from other methods}
}
\value{
object of class \code{"DIFtree"}.
An object of class \code{"DIFtree"} is a list containing the following components:

\item{splits}{Matrix with detailed information about all executed splits during the estimation process}
\item{theta_hat}{Estimated person abilities}
\item{beta_hat_nodif}{Estimated item difficulties for items without DIF}
\item{beta_hat_dif}{List of estimated item difficulties for items with DIF.
Each element contains diffculties for one item.}
\item{pvalues}{P-values of each permutation test during the estimation process}
\item{Y}{Response matrix used in the estimation process}
\item{X}{Model matrix used in the estimation process}
\item{persons}{Number of persons}
\item{items}{Number of items}
}
\description{
A function to estimate Item focussed trees for simultaneous selection of items and variables
that induce DIF (Differential Item Functioning) in Item Response models.
The method of item focussed recursive partitioning is described in Tutz and Berger (2015).
}
\details{
The method assumes a Rasch model where DIF can appear in some of the items.
Items with DIF are gradually identified by recursive partitioning.
In each iteration of the algorithm one item, variable and threshold ist chosen for splitting.
Significance of the split is verified by permutation tests.
The result of the permutation test can strongly depend on the number of permutations \code{nperm}.

In the case of pure terminal nodes estimates of the model do not exist. If \code{penalize=TRUE}
a small ridge penalty is added during estimation to ensure existence of all parameters.
}
\examples{
data(data_sim)

Y <- data_sim[,1]
X <- data_sim[,-1]

\dontrun{

mod <- DIFtree(Y=Y,X=X,alpha=0.05,nperm=100,trace=TRUE)

print(mod)
summary(mod)
}
}
\author{
Moritz Berger <moritz.berger@stat.uni-muenchen.de> \cr \url{http://www.statistik.lmu.de/~mberger/}
}
\references{
Tutz, Gerhard and Berger, Moritz (2015): Item Focused Trees for the Identification of Items
in Differential Item Functioning, Department of Statistics, LMU Munich
}
\seealso{
\code{\link[DIFtree]{plot.DIFtree}}, \code{\link[DIFtree]{predict.DIFtree}}
}

