% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LS.R
\name{LS}
\alias{LS}
\title{Least Squares Estimation for Grouped Data with Ridge Regularization}
\usage{
LS(d, yidx, Xidx, n, lam = 0.005)
}
\arguments{
\item{d}{A data frame containing dependent and independent variables.}

\item{yidx}{The column index of the dependent variable.}

\item{Xidx}{The column indices of the independent variables.}

\item{n}{A vector of starting indices for the groups.}

\item{lam}{Regularization parameter for ridge regression, default is 0.005.}
}
\value{
A list containing the following elements:
\item{beta}{A matrix of regression coefficients for each group.}
\item{SSE}{The sum of squared residuals for each group.}
\item{df}{The sample size for each group.}
\item{gram}{The Gram matrix for each group.}
\item{cgram}{The Cholesky decomposition result for each group.}
\item{comm}{An unused variable (reserved for future expansion).}
}
\description{
This function implements the least squares estimation for grouped data, 
supporting ridge regression regularization. It can handle missing data 
and returns regression coefficients and the sum of squared residuals for each group.
}
\examples{
# Example data
set.seed(123)
n <- 1000
p <- 5
d <- list(all = cbind(rnorm(n), matrix(rnorm(n*p), ncol=p)))

# Call the LS function
result <- LS(d, yidx = 1, Xidx = 2:(p + 1), n = c(1, 300, 600, 1000))

# View the results
print(result$beta)  # Regression coefficients
print(result$SSE)   # Sum of squared residuals

}
