% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{popdyn}
\alias{popdyn}
\title{Population dynamics model}
\usage{
popdyn(nareas, maxage, Ncurr, pyears, M_age, Asize_c, MatAge, WtAge, Vuln, Retc,
  Prec, movc, SRrelc, Effind, Spat_targc, hc, R0c, SSBpRc, aRc, bRc, Qc,
  Fapic = NULL, maxF, control = 1)
}
\arguments{
\item{nareas}{Integer. The number of spatial areas}

\item{maxage}{Integer. The maximum age}

\item{Ncurr}{Numeric matrix (dimensions maxage, nareas) with the current N-at-age}

\item{pyears}{Integer. Number of years to project the model forward}

\item{M_age}{Numeric matrix (dimensions maxage, pyears) with natural mortality at age}

\item{Asize_c}{Numeric vector (length nareas) with size of each area}

\item{MatAge}{Numeric matrix (dimensions maxage, nyears+proyears) with proportion mature for each age-class}

\item{WtAge}{Numeric matrix (dimensions maxage, pyears) with weight-at-age}

\item{Vuln}{Numeric matrix (dimensions maxage, pyears) with proportion vulnerable-at-age}

\item{Retc}{Numeric matrix (dimensions maxage, pyears) with proportion retained-at-age}

\item{Prec}{Numeric vector (length pyears) with recruitment error}

\item{movc}{Numeric matrix (dimensions nareas, nareas) with movement matrix}

\item{SRrelc}{Integer. Stock-recruitment curve}

\item{Effind}{Numeric vector (length pyears) with the fishing effort by year}

\item{Spat_targc}{Integer. Value of spatial targetting}

\item{hc}{Numeric. Steepness of stock-recruit relationship}

\item{R0c}{Numeric vector of length nareas with unfished recruitment by area}

\item{SSBpRc}{Numeric vector of length nareas with unfished spawning per recruit by area}

\item{aRc}{Numeric. Ricker SRR a value}

\item{bRc}{Numeric. Ricker SRR b value}

\item{Qc}{Numeric. Catchability coefficient}

\item{Fapic}{Numeric. Apical F value}

\item{maxF}{A numeric value specifying the maximum fishing mortality for any single age class}

\item{control}{Integer. 1 to use q and effort to calculate F, 2 to use Fapic (apical F) and 
vulnerablity to calculate F.}
}
\value{
A named list of length 8 containing with arrays (dimensions: maxage, pyears, nareas)
containing numbers-at-age, biomass-at-age, spawning stock numbers, spawning biomass, 
vulnerable biomass, fishing mortality, retained fishing mortality, and total mortality
}
\description{
Population dynamics model
}
\author{
A. Hordyk
}
