% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Output.R
\name{Fratio}
\alias{Fratio}
\alias{Fratio4010}
\alias{DepF}
\alias{Fratio_CC}
\alias{Fratio_ML}
\title{FMSY/M ratio methods}
\usage{
Fratio(x, Data, reps = 100, plot = FALSE)

Fratio4010(x, Data, reps = 100, plot = FALSE)

DepF(x, Data, reps = 100, plot = FALSE)

Fratio_CC(x, Data, reps = 100, plot = FALSE, Fmin = 0.005)

Fratio_ML(x, Data, reps = 100, plot = FALSE)
}
\arguments{
\item{x}{A position in a data-limited methods data object}

\item{Data}{A data-limited methods data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{Fmin}{Minimum current fishing mortality rate for the catch-curve analysis}
}
\value{
An object of class \code{\link[=Rec-class]{Rec}} with the \code{TAC} slot populated with a numeric vector of length \code{reps}
}
\description{
Calculates the OFL based on a fixed ratio of FMSY to M multiplied by a
current estimate of abundance.

A simple method that tends to outperform many other approaches alarmingly
often even when current biomass is relatively poorly known. The low stock
crash potential is largely due to the quite large difference between Fmax
and FMSY for most stocks.
}
\details{
The TAC is calculated as:
\deqn{\textrm{TAC} = F_{\textrm{MSY}} A}
where \eqn{F_{\textrm{MSY}}} is calculated as \eqn{\frac{F_\textrm{MSY}}{M} M} and
\emph{A} is estimate of current abundance.

The MP variants differ in the assumption of current abundance (see Functions section below)
}
\section{Functions}{
\itemize{
\item \code{Fratio}: Requires an estimate of current abundance (i.e \code{Data@Abun})

\item \code{Fratio4010}: Paired with the 40-10 rule that throttles back the OFL to zero at 10 percent of unfished biomass. Requires an estimate of current depletion.

\item \code{DepF}: Depletion Corrected Fratio: the Fratio MP with a harvest control
rule that reduces F according to the production curve given an estimate of current
stock depletion (made-up for this package).

\item \code{Fratio_CC}: Current abundance is estimated using average catch and estimate of F from an age-based catch curve

\item \code{Fratio_ML}: Current abundance is estimated using average catch and estimate of F from mean lengths
}}

\section{Required Data}{

See \linkS4class{Data} for information on the \code{Data} object \cr


\code{Fratio}: Abun, FMSY_M, Mort


\code{Fratio4010}: Abun, Dep, FMSY_M, Mort


\code{DepF}: Abun, Dep, FMSY_M, Mort


\code{Fratio_CC}: CAA, Cat, FMSY_M, Mort


\code{Fratio_ML}: CAL, CAL_bins, Cat, FMSY_M, LFS, Mort, vbK, vbLinf
}

\section{Rendered Equations}{
 
See \href{https://dlmtool.github.io/DLMtool/reference/Fratio.html}{Online Documentation} for correctly rendered equations








}

\examples{
Fratio(1, DLMtool::Atlantic_mackerel, plot=TRUE)
Fratio4010(1, DLMtool::Atlantic_mackerel, plot=TRUE)
Fratio_CC(1, DLMtool::SimulatedData, plot=TRUE)
Fratio_ML(1, DLMtool::SimulatedData, plot=TRUE)

}
\references{
Gulland, J.A., 1971. The fish resources of the ocean. Fishing
News Books, West Byfleet, UK.

Martell, S., Froese, R., 2012. A simple method for estimating MSY from catch
and resilience. Fish Fish. doi: 10.1111/j.1467-2979.2012.00485.x.
}
\seealso{
Other Fmsy/M methods: \code{\link{DynF}},
  \code{\link{Fadapt}}
}
\author{
T. Carruthers
}
