% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{popdynOneTScpp}
\alias{popdynOneTScpp}
\title{Population dynamics model for one annual time-step}
\usage{
popdynOneTScpp(
  nareas,
  maxage,
  SSBcurr,
  Ncurr,
  Zcurr,
  PerrYr,
  hs,
  R0a,
  SSBpR,
  aR,
  bR,
  mov,
  SRrel,
  plusgroup = 0L
)
}
\arguments{
\item{nareas}{The number of spatial areas}

\item{maxage}{The maximum age}

\item{SSBcurr}{A numeric vector of length nareas with the current spawning biomass in each area}

\item{Ncurr}{A numeric matrix (maxage, nareas) with current numbers-at-age in each area}

\item{Zcurr}{A numeric matrix (maxage, nareas) with total mortality-at-age in each area}

\item{PerrYr}{A numeric value with recruitment deviation for current year}

\item{hs}{Steepness of SRR}

\item{R0a}{Numeric vector with unfished recruitment by area}

\item{SSBpR}{Numeric vector with unfished spawning stock per recruit by area}

\item{aR}{Numeric vector with Ricker SRR a parameter by area}

\item{bR}{Numeric vector with Ricker SRR b parameter by area}

\item{mov}{Numeric matrix (nareas by nareas) with the movement matrix}

\item{SRrel}{Integer indicating the stock-recruitment relationship to use (1 for Beverton-Holt, 2 for Ricker)}
}
\description{
Project population forward one time-step given current numbers-at-age and total mortality
}
\author{
A. Hordyk
}
\keyword{internal}
