% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dmcfitvp}
\alias{plot.dmcfitvp}
\title{plot.dmcfitvp}
\usage{
\method{plot}{dmcfitvp}(
  x,
  y,
  figType = "summary",
  VP = NULL,
  legend = TRUE,
  labels = c("Compatible", "Incompatible", "Observed", "Predicted"),
  cols = c("black", "green", "red"),
  ylimRt = c(200, 800),
  ylimEr = c(0, 20),
  ylimCAF = c(0, 1),
  cafBinLabels = FALSE,
  ylimDelta = c(-50, 100),
  xlimDelta = c(200, 1000),
  xlabs = TRUE,
  ylabs = TRUE,
  xaxts = TRUE,
  yaxts = TRUE,
  resetPar = TRUE,
  ...
)
}
\arguments{
\item{x}{Output from dmcFitVPs}

\item{y}{Observed data}

\item{figType}{summary, rtCorrect, errorRate, rtErrors, cdf, caf, delta, all}

\item{VP}{NULL (aggregated data across all participants) or integer for participant number}

\item{legend}{TRUE/FALSE (or FUNCTION) plot legend on each plot}

\item{labels}{Condition labels c("Compatible", "Incompatible", "Observed", "Predicted") default}

\item{cols}{Condition colours c("green", "red") default}

\item{ylimRt}{ylimit for Rt plots}

\item{ylimEr}{ylimit for error rate plots}

\item{ylimCAF}{ylimit for CAF plot}

\item{cafBinLabels}{TRUE/FALSE}

\item{ylimDelta}{ylimit for delta plot}

\item{xlimDelta}{xlimit for delta plot}

\item{xlabs}{TRUE/FALSE}

\item{ylabs}{TRUE/FALSE}

\item{xaxts}{TRUE/FALSE}

\item{yaxts}{TRUE/FALSE}

\item{resetPar}{TRUE/FALSE Reset graphical parameters}

\item{...}{additional plot pars}
}
\description{
Plot the simulation results from the output of dmcFitVPs. The plot
can be an overall summary, or individual plots (activation, trials, pdf, cdf,
caf, delta, all). Plot type summary1 contains an activation plot, example
individual trials, the probability distribution function (PDF), the cumulative
distribution function (CDF), the conditional accuracy function (CAF) and
delta plots. This required that dmcSim is run with fullData = TRUE. Plot type
summary2 contains only the PDF, CDF, CAF and delta plots and does not require
that dmcSim is run with fullData = TRUE.
}
\examples{
\donttest{
# Example 1
resTh <- dmcFitVPs(flankerData, nTrl = 5000, VP = c(2, 3))
plot(resTh, flankerData)
plot(flankerData, VP = 2)
plot(resTh, flankerData)
}

}
