% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{mean.dmcfit}
\alias{mean.dmcfit}
\title{mean.dmcfit}
\usage{
\method{mean}{dmcfit}(x, ...)
}
\arguments{
\item{x}{Output from dmcFitSubject/dmcFitSubjectDE}

\item{...}{pars}
}
\value{
mean.dmcfit return an object of class "dmcfit" with the following components:
\item{summary}{DataFrame within aggregated subject data (rtCor, sdRtCor, seRtCor, perErr, sdPerErr, sePerErr, rtErr, sdRtErr, seRtErr) for compatibility condition}
\item{delta}{DataFrame within aggregated subject distributional delta analysis data correct trials (Bin, meanComp, meanIncomp, meanBin, meanEffect, sdEffect, seEffect)}
\item{caf}{DataFrame within aggregated subject conditional accuracy function (CAF) data (Bin, accPerComp, accPerIncomp, meanEffect, sdEffect, seEffect)}
\item{par}{The fitted model parameters + final cost value of the fit}
}
\description{
Aggregate simulation results from dmcFitSubject/dmcFitSubjectDE.
}
\examples{
\donttest{
# Code below can exceed CRAN check time limit, hence donttest
# Example 1: Fit individual data then aggregate
fitSubjects <- dmcFitSubject(flankerData, nTrl = 1000, subjects = c(1, 2))
fitAgg <- mean(fitSubjects)
plot(fitAgg, flankerData)
}

}
