% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcData.R
\name{calculateDelta}
\alias{calculateDelta}
\title{calculateDelta}
\usage{
calculateDelta(
  dat,
  nDelta = 19,
  tDelta = 1,
  columns = c("Subject", "Comp", "RT"),
  compCoding = c("comp", "incomp"),
  quantileType = 5
)
}
\arguments{
\item{dat}{DataFrame with columns containing the participant number, condition
compatibility, and RT data (in ms).}

\item{nDelta}{The number of delta bins.}

\item{tDelta}{type of delta calculation (1=direct percentiles points, 2=percentile bounds (tile) averaging)}

\item{columns}{Name of required columns Default: c("Subject", "Comp", "RT")}

\item{compCoding}{Coding for compatibility Default: c("comp", "incomp")}

\item{quantileType}{Argument (1-9) from R function quantile specifying the algorithm (?quantile)}
}
\value{
calculateDelta returns a DataFrame with distributional delta analysis data (Bin, comp, incomp, meanBin, Effect)
}
\description{
Calculate delta plot. Here RTs are split into n bins (Default: 5) for compatible and
incompatible trials separately. Mean RT is calculated for each condition in each bin then
subtracted (incompatible - compatible) to give a compatibility effect (delta) at each bin.
}
\examples{
# Example 1
dat <- createDF(nSubjects = 1, nTrl = 10000, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
                 RT = list("Comp_comp"   = c(500, 80, 100),
                           "Comp_incomp" = c(600, 80, 140)))
delta <- calculateDelta(dat)

# Example 2
dat <- createDF(nSubject = 1, nTrl = 10000, design = list("Congruency" = c("cong", "incong")))
dat <- addDataDF(dat,
                 RT = list("Congruency_cong"   = c(500, 80, 100),
                           "Congruency_incong" = c(600, 80, 140)))
head(dat)
delta <- calculateDelta(dat, nDelta = 9, columns = c("Subject", "Congruency", "RT"),
                        compCoding = c("cong", "incong"))

}
