% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.DMR.R
\name{plot.cv.DMR}
\alias{plot.cv.DMR}
\title{plot.cv.DMR}
\usage{
\method{plot}{cv.DMR}(x, ...)
}
\arguments{
\item{x}{Fitted \code{cv.DMR} object.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
Plots cross-validated error values from a \code{cv.DMR} object.
}
\details{
Produces a plot of cross-validated error values for the entire sequence of models from the fitted \code{cv.DMR} object. The horizontal level indicating separation of one standard deviation from the minimum error is indicated with a blue dashed line. The df.min (the smallest model minimizing the cross-validated error) and df.1se (the smallest model falling under the blue dashed line) are marked with red and blue points, respectively.
}
\examples{
## cv.DMR for linear regression
set.seed(13)
data(miete)
y <- miete$rent
X <- miete$area
cv = cv.DMR(X,y)
plot(cv)

}
