% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compress_lookup.R
\name{compress_lookup}
\alias{compress_lookup}
\title{Collapse Redundant Rows of a Lookup Table}
\usage{
compress_lookup(
  lookupTable,
  compressCategory = FALSE,
  compressClass = FALSE,
  compressSynonym = TRUE,
  sortOutput = FALSE
)
}
\arguments{
\item{lookupTable}{A lookup table with class \code{data.frame} having three
columns: drug category, drug class, and drug street name. These tables are
returned by the function \code{\link{lookup}}.}

\item{compressCategory}{Should the drug category be collapsed? Defaults to
\code{FALSE}.}

\item{compressClass}{Should the drug class be collapsed? Defaults to
\code{FALSE}.}

\item{compressSynonym}{Should the drug synonym / street name be collapsed?
Defaults to \code{TRUE}.}

\item{sortOutput}{Sort alphabetically rows of the returned table. Defaults
to FALSE (maintaining the row order of the original \code{lookupTable}
object).}
}
\value{
A compressed lookup table, with unwanted columns removed.
}
\description{
Given a Drug Lookup table as returned by the function
\code{\link{lookup}}, collapse rows from unwanted columns
}
\examples{
  longExampleTable <- lookup("dope", "methamphetamine")
  compress_lookup(longExampleTable)
  compress_lookup(longExampleTable, compressClass = TRUE)
}
