% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_plots.R
\name{generate_plots}
\alias{generate_plots}
\title{A helper function that takes result from the simulators and produces plots}
\usage{
generate_plots(res)
}
\arguments{
\item{res}{a list structure containing all simulation results that are to be plotted.
The length of the list indicates the number of separate plots to make.
Each list entry corresponds to one plot and
needs to contain the following information/elements:
1. a data frame called "dat" or "ts". If the data frame is "ts" it is assumed to be 
a time series and by default a line plot will be produced and labeled Time/Numbers. 
For plotting, the data needs to be in a format with one column called xvals, one column yvals,
one column called varnames that contains names for different variables.
Varnames needs to be a factor variable or will be converted to one.
If a column 'varnames' exist, it is assumed the data is in the right format. Otherwise it will be transformed.
An optional column called IDvar can be provided for further grouping (i.e. multiple lines for stochastic simulations).
If plottype is 'mixedplot' an additional column called 'style' indicating line or point plot
for each variable is needed.
2. meta-data for the plot, provided in the following variables:
optional: plottype - one of "Lineplot" (default is nothing is provided),"Scatterplot","Boxplot", "Mixedplot".
optional: xlab, ylab - strings to label axes.
optional: xscale, yscale - scaling of axes, valid ggplot2 expression, e.g. "identity" or "log10".
optional: xmin, xmax, ymin, ymax - manual min and max for axes.
optional: legendtitle - legend title, if NULL/not supplied no legend will be plotted.
optional: linesize - width of line, numeric, i.e. 1.5, 2, etc. set to 1.5 if not supplied.
optional: title - a title for each plot.}
}
\value{
A plot structure for display in a Shiny UI
}
\description{
This function generates plots to be displayed in the Shiny UI.
This is a helper function. This function processes results returned from the simulation, supplied as a list
}
\details{
This function is called by the Shiny server to produce plots returned to the Shiny UI
To create plots run the simulation with default parameters, just call a function, e.g.:
result <- simulate_basicbacteria()
}
\author{
Andreas Handel
}
