% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_idpatterns_ode.R
\name{simulate_idpatterns_ode}
\alias{simulate_idpatterns_ode}
\title{Simulation of a compartmental infectious disease transmission model including seasonality}
\usage{
simulate_idpatterns_ode(
  S = 1000,
  P = 1,
  bP = 0,
  bA = 0,
  bI = 0.001,
  s = 0,
  gP = 0.5,
  gA = 0.5,
  gI = 0.5,
  f = 0,
  d = 0,
  w = 0,
  m = 0,
  n = 0,
  timeunit = 1,
  tmax = 300
)
}
\arguments{
\item{S}{: initial number of susceptible hosts : numeric}

\item{P}{: initial number of infected, pre-symptomatic hosts : numeric}

\item{bP}{: level/rate of infectiousness for hosts in the P compartment : numeric}

\item{bA}{: level/rate of infectiousness for hosts in the A compartment : numeric}

\item{bI}{: level/rate of infectiousness for hosts in the I compartment : numeric}

\item{s}{: strength of seasonal/annual sigmoidal variation of transmission rate : numeric}

\item{gP}{: rate at which a person leaves the P compartment : numeric}

\item{gA}{: rate at which a person leaves the A compartment : numeric}

\item{gI}{: rate at which a person leaves the I compartment : numeric}

\item{f}{: fraction of pre-symptomatic individuals that have an asymptomatic infection : numeric}

\item{d}{: fraction of symptomatic infected hosts that die due to disease : numeric}

\item{w}{: rate at which recovered persons lose immunity and return to susceptible state : numeric}

\item{m}{: the rate at which new individuals enter the model (are born) : numeric}

\item{n}{: the rate of natural death (the inverse it the average lifespan) : numeric}

\item{timeunit}{: units of time in which the model should run (1=day, 2=week, 3=month, 4=year) : numeric}

\item{tmax}{: maximum simulation time, in units of months : numeric}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver.
}
\description{
Simulation of a compartmental model with several different compartments:
  Susceptibles (S), Infected and Pre-symptomatic (P),
  Infected and Asymptomatic (A), Infected and Symptomatic (I),
  Recovered and Immune (R) and Dead (D).

  This model includes natural births and deaths and waning immunity.
  It also allows for seasonal variation in transmission.
  The model is assumed to run in units of months.
  This assumption is hard-coded into the sinusoidally varying
  transmission coefficient, which is assumed to have a period of a year.
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. have I0 > PopSize or any negative values or fractions > 1),
  the code will likely abort with an error message.
}

\examples{
  # To run the simulation with default parameters just call the function:
  result <- simulate_idpatterns_ode()
  # To choose parameter values other than the standard one, specify them like such:
  result <- simulate_idpatterns_ode(S = 2000, P = 10, tmax = 100, f = 0.1, d = 0.2, s = 0.1)
  # You should then use the simulation result returned from the function, like this:
  plot(result$ts[ , "time"],result$ts[ , "S"],xlab='Time',ylab='Number Susceptible',type='l')
}
\references{
See e.g. Keeling and Rohani 2008 for SIR models and the
  documentation for the deSolve package for details on ODE solvers
}
\seealso{
The UI of the app, which is part of this package, contains more details on the model.
}
\author{
Andreas Handel
}
