% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_drugresistance_stochastic.R
\name{simulate_drugresistance_stochastic}
\alias{simulate_drugresistance_stochastic}
\title{Stochastic simulation of a compartmental acute virus infection model
with treatment and drug resistant strain}
\usage{
simulate_drugresistance_stochastic(U = 1e+05, Is = 0, Ir = 0,
  Vs = 10, Vr = 0, b = 1e-05, dI = 1, e = 0, m = 1e-04,
  p = 100, c = 4, f = 0.1, rngseed = 100, tfinal = 100)
}
\arguments{
\item{U}{: initial number of target cells : numeric}

\item{Is}{: initial number of wild-type infected cells : numeric}

\item{Ir}{: initial number of resistant infected cells : numeric}

\item{Vs}{: initial number of wild-type virus : numeric}

\item{Vr}{: initial number of resistant virus : numeric}

\item{b}{: level/rate of infection of cells : numeric}

\item{dI}{: rate of infected cell death : numeric}

\item{e}{: efficacy of drug : numeric}

\item{m}{: fraction of resistant mutants created : numeric}

\item{p}{: virus production rate : numeric}

\item{c}{: virus removal rate : numeric}

\item{f}{: fitness cost of resistant virus : numeric}

\item{rngseed}{: seed for random number generator to allow reproducibility : numeric}

\item{tfinal}{: maximum simulation time : numeric}
}
\value{
A list. The list has only one element called ts.
ts contains the time-series of the simulation.
The 1st column of ts is Time, the other columns are the model variables.
}
\description{
Simulation of a stochastic model with the following compartments:
Uninfected target cells (U), Infected with wild-type/sensitive and untreated (Is),
infected with resistant (Ir), wild-type virus (Vs), resistant virus (Vr).
}
\details{
A compartmental ID model with several states/compartments
is simulated as a stochastic model using the adaptive tau algorithm as implemented by ssa.adaptivetau
in the adpativetau package. See the manual of this package for more details.
The function returns the time series of the simulated disease as output matrix,
with one column per compartment/variable. The first column is time.
}
\section{Warning}{

This function does not perform any error checking. So if you try to do
something nonsensical (e.g. have I0 > PopSize or any negative values or fractions > 1),
the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_drugresistance_stochastic()
# To choose parameter values other than the standard one, specify them, like such:
result <- simulate_drugresistance_stochastic(tfinal = 200, e = 0.5)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,"time"],result$ts[,"Vs"],xlab='Time',ylab='Uninfected cells',type='l')
}
\references{
See the manual for the adaptivetau package for details on the algorithm.
            The implemented model is loosely based on: Handel et al 2007 PLoS Comp Bio
           "Neuraminidase Inhibitor Resistance in Influenza: Assessing the Danger of Its
           Generation and Spread"
}
\author{
Andreas Handel
}
