% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSLiteConnection.R
\name{dsAssignTable,DSLiteConnection-method}
\alias{dsAssignTable,DSLiteConnection-method}
\title{Assign a table}
\usage{
\S4method{dsAssignTable}{DSLiteConnection}(
  conn,
  symbol,
  table,
  variables = NULL,
  missings = FALSE,
  identifiers = NULL,
  id.name = NULL,
  async = TRUE
)
}
\arguments{
\item{conn}{\code{\link{DSLiteConnection-class}} object.}

\item{symbol}{Name of the R symbol.}

\item{table}{Fully qualified name of a dataset living in the DSLite server.}

\item{variables}{The variable names to be filtered in.}

\item{missings}{Ignored.}

\item{identifiers}{Name of the identifiers mapping to use when assigning entities to R (currently NOT supported by DSLite).}

\item{id.name}{Name of the column that will contain the entity identifiers. If not specified, the identifiers
will be the data frame row names. When specified this column can be used to perform joins between data frames.}

\item{async}{Whether the result of the call should be retrieved asynchronously. When TRUE (default) the calls are parallelized over
the connections, when the connection supports that feature, with an extra overhead of requests.}
}
\value{
A \code{\link{DSLiteResult-class}} object.
}
\description{
Assign a DSLite dataset in the DataSHIELD R session.
}
