% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dsspMod}
\alias{plot.dsspMod}
\title{Diagnostic, Density and Contour Plots}
\usage{
\method{plot}{dsspMod}(
  x,
  robust_residuals = TRUE,
  contour_plots = TRUE,
  nx = 100,
  ny = 100,
  nlevels = 5,
  ...
)
}
\arguments{
\item{x}{an object of class \code{dsspMod}}

\item{robust_residuals}{whether to use robust residuals (median of predicted).
Default to be \code{TRUE}.}

\item{contour_plots}{whether or not to return a second panel with contour plots.
Defaults to \code{TRUE}}

\item{nx}{dimension of output grid in x direction.
Used for interpolation (\code{akime::interp()}).}

\item{ny}{dimension of output grid in y direction.
Used for interpolation (\code{akime::interp()}).}

\item{nlevels}{number of levels used in contour plot.}

\item{...}{additional arguments that are passed to \code{ggplot2::scale_fill_distiller()}.}
}
\value{
a list containing the plots printed (individually and together in grid)
}
\description{
Diagnostic, Density and Contour Plots
}
\examples{
library(sp)
library(gstat)
data(meuse.all)
coordinates(meuse.all) <- ~ x + y

f <- function(x) -x ## log-prior for exponential distribution for the smoothing parameter

## Draw 100 samples from the posterior of eta given the data y.
OUTPUT <- DSSP(
  formula = log(zinc) ~ 1, data = meuse.all, N = 100,
  pars = c(0.001, 0.001), log_prior = f
)
plot(OUTPUT, contour_plots = FALSE)
}
