% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imptPower.R
\name{imptPower}
\alias{imptPower}
\title{Power imputation}
\usage{
imptPower(
  data,
  powercol,
  vcol,
  vrange,
  rated.power = NULL,
  sample = TRUE,
  size = 2500
)
}
\arguments{
\item{data}{A list of two data sets that require imputation.}

\item{powercol}{A numeric stating the column number of power production.}

\item{vcol}{A numeric stating the column number of wind speed.}

\item{vrange}{A vector of cut-in, rated, and cut-out wind speed.}

\item{rated.power}{A numerical value stating the wind turbine rated power.}

\item{sample}{A boolean (TRUE/FALSE) indicating whether to use sample or the whole data sets to train the power curve.}

\item{size}{A numeric stating the size of sample when \code{sample = TRUE}. Default value is 2500. It is only used when \code{sample = TRUE}.}
}
\value{
a list containing datasets with the imputed power.
}
\description{
Good power curve modeling requires valid power values in the region between cut-in and cut-out wind speed. However, when turbine is not operating, the power production will be recorded as zero or negative. This function replaces those values with predicted values obtained from the estimated tempGP power curve model using one input variable - the wind speed.
}
\examples{

data = list(data1[1:100,], data2[1:120, ])
powercol = 7
vcol = 2
vrange = c(5,12,25)
rated.power = 100
sample = FALSE

imputed.dat = imptPower(data, powercol, vcol, vrange, rated.power, sample)

}
\references{
Latiffianti, E, Ding, Y, Sheng, S, Williams, L, Morshedizadeh, M, Rodgers, M (2022). "Analysis of leading edge protection application on wind turbine performance through energy and power decomposition approaches". Wind Energy. 2022; 1-19. \doi{10.1002/we.2722}.
}
