% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendall.w.R
\name{kendall.w}
\alias{kendall.w}
\title{Kendall's coefficient of concordance W}
\usage{
kendall.w(raw, correct = TRUE)
}
\arguments{
\item{raw}{A data frame or matrix contains n subjects * m raters.}

\item{correct}{Logical. Indicates whether the W should be corrected for ties
within raters.}
}
\value{
The resulting list consists of `title`, `kendall.w`, `chisq`, `df`,
`pval`, `report`.
}
\description{
Computes the Kendall's coefficient of concordance.
}
\examples{
library(DTSEA)
library(tibble)

# Load the data
data <- tribble(~x, ~y, ~z, 1,1,2,  5,6,5,  7,8,4, 2,3,2, 8,6,5)

# Run Kendall's W
print(kendall.w(data)$report)
}
