% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funby.R
\name{TALFs}
\alias{TALFs}
\alias{byFasttimeY_____}
\alias{byFasttimeYQ____}
\alias{byFasttimeYm____}
\alias{byFasttimeYmd___}
\alias{byFasttimeYmdH__}
\alias{byFasttimeYmdHM_}
\alias{byFasttimeYmdHMS}
\alias{byFasttime______}
\alias{byFasttime_Q____}
\alias{byFasttime_m____}
\alias{byFasttime___H__}
\alias{byFasttime____M_}
\alias{byFasttime_____S}
\alias{byY_____}
\alias{byYQ____}
\alias{byYm____}
\alias{byYmd___}
\alias{byYmdH__}
\alias{byYmdHM_}
\alias{byYmdHMS}
\alias{by______}
\alias{by_Q____}
\alias{by_m____}
\alias{by___H__}
\alias{by____M_}
\alias{by_____S}
\title{Temporal Aggregation Level Functions}
\usage{
byFasttimeY_____(.dateTime, .helpers)

byFasttimeYQ____(.dateTime, .helpers)

byFasttimeYm____(.dateTime, .helpers)

byFasttimeYmd___(.dateTime, .helpers)

byFasttimeYmdH__(.dateTime, .helpers)

byFasttimeYmdHM_(.dateTime, .helpers)

byFasttimeYmdHMS(.dateTime, .helpers)

byFasttime______(.dateTime, .helpers)

byFasttime_Q____(.dateTime, .helpers)

byFasttime_m____(.dateTime, .helpers)

byFasttime___H__(.dateTime, .helpers)

byFasttime____M_(.dateTime, .helpers)

byFasttime_____S(.dateTime, .helpers)

byY_____(.dateTime, .helpers)

byYQ____(.dateTime, .helpers)

byYm____(.dateTime, .helpers)

byYmd___(.dateTime, .helpers)

byYmdH__(.dateTime, .helpers)

byYmdHM_(.dateTime, .helpers)

byYmdHMS(.dateTime, .helpers)

by______(.dateTime, .helpers)

by_Q____(.dateTime, .helpers)

by_m____(.dateTime, .helpers)

by___H__(.dateTime, .helpers)

by____M_(.dateTime, .helpers)

by_____S(.dateTime, .helpers)
}
\arguments{
\item{.dateTime}{A \code{\link{POSIXct}} vector.}

\item{.helpers}{A \code{\link{list}} with helper data as handed over by
\code{\link{DTSg}} objects' \code{\link{aggregate}} method.}
}
\value{
All functions return a \code{\link{POSIXct}} vector with timestamps
 corresponding to the function's temporal aggregation level.
}
\description{
Simply hand over one of these functions to the \code{funby} argument of one
 of the methods (e.g. \code{\link{aggregate}}) of \code{\link{DTSg}} objects
 which support it. The method does the rest of the work. See details for
 further information. Other uses are possible, but not recommended.
}
\details{
There are two families of temporal aggregation level functions. The
 one family truncates timestamps (truncating family), the other extracts a
 certain part of them (extracting family). Each family comes in two flavours:
 one using \code{\link[fasttime]{fastPOSIXct}} of \pkg{fasttime}, the other
 solely relying on base \R. The \pkg{fasttime} versions work with UTC time
 series or time series with an equivalent time zone only (execute
 \code{grep("^(Etc/)?(UCT|UTC)$|^(Etc/)?GMT(\\+|-)?0?$", OlsonNames(),
 ignore.case = TRUE, value = TRUE)} for a full list of supported time zones)
 and are limited to dates between the years 1970 and 2199, but generally are
 faster for the extracting family of functions.

The truncating family sets timestamps to the lowest possible time of the
 corresponding temporal aggregation level:
 \itemize{
   \item \code{*Y_____} truncates to year,    e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2000-01-01 00:00:00.0}
   \item \code{*YQ____} truncates to quarter, e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2000-10-01 00:00:00.0}
   \item \code{*Ym____} truncates to month,   e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2000-11-01 00:00:00.0}
   \item \code{*Ymd___} truncates to day,     e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2000-11-11 00:00:00.0}
   \item \code{*YmdH__} truncates to hour,    e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2000-11-11 11:00:00.0}
   \item \code{*YmdHM_} truncates to minute,  e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2000-11-11 11:11:00.0}
   \item \code{*YmdHMS} truncates to second,  e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2000-11-11 11:11:11.0}
 }

By convention, the extracting family sets the year to 2199 and extracts a
 certain part of timestamps:
 \itemize{
   \item \code{*______} extracts nothing,      i.e.               all timestamps become  \emph{2199-01-01 00:00:00.0}
   \item \code{*_Q____} extracts the quarters, e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2199-10-01 00:00:00.0}
   \item \code{*_m____} extracts the months,   e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2199-11-01 00:00:00.0}
   \item \code{*___H__} extracts the hours,    e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2199-01-01 11:00:00.0}
   \item \code{*____M_} extracts the minutes,  e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2199-01-01 00:11:00.0}
   \item \code{*_____S} extracts the seconds,  e.g. \emph{2000-11-11 11:11:11.1} becomes \emph{2199-01-01 00:00:11.0}
 }
}
\seealso{
\code{\link{DTSg}}, \code{\link{aggregate}}, \code{\link{colapply}},
 \code{\link{subset}}, \code{\link[fasttime]{fastPOSIXct}},
 \code{\link{list}}, \code{\link{POSIXct}}
}
