% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.remove.variables.R
\name{dt.remove.variables}
\alias{dt.remove.variables}
\title{dt.remove.variables}
\source{
DTwrappers::create.dt.statement

DTwrappers::eval.dt.statement
}
\usage{
dt.remove.variables(
  dt.name,
  the.variables,
  return.as = "result",
  envir = .GlobalEnv,
  ...
)
}
\arguments{
\item{dt.name}{a character value specifying the name of a data.frame or data.table object to select data from.  A variable called dat should be referred to with dt.name = "dat" when using the function.}

\item{the.variables}{A character or numeric vector specifying the variables that we want to remove. For character vectors, only values that exist in the names of the data will be used.  For numeric vectors, only the values of unique(floor(sorting.variables)) that are in 1:ncol() of your data will be used.  Then these indices will be used to select column names from the data.}

\item{return.as}{a character value specifying what output should be returned.  return.as = "result" provides the updated data.  return.as = "code" provides a data.table coding statement.  return.as = "all" provides a list object including both the resulting output and the code.}

\item{envir}{a specification of the environment in which the data (referenced by dt.name) exists, with the global environment as the default value.#'}

\item{...}{additional arguments if required}
}
\value{
a `data.table` object.
}
\description{
A function to remove selected columns from a data.frame or data.table object.
}
\examples{
n <- nrow(iris)
dat <- data.table::as.data.table(x = iris[sample(x = 1:n, size = n, replace = FALSE),])
dt.remove.variables(dt.name = "dat", the.variables = c("Category", "setosa_sl_below_5"),
return.as = "all")


}
