% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_state.R
\name{init_state}
\alias{init_state}
\title{Initial conditions of the model}
\usage{
init_state(raster)
}
\arguments{
\item{raster}{It could be a raster containing the maximum storage in the root zone or two raster with the initial conditions of storage}
}
\value{
A list containing initial conditions in storage and in ground.
}
\description{
This function uploads or creates the initial conditions of the two-state variables present in the DWB model, in raster format.
}
\details{
It requires the raster composed of the Srmax values that were created using the \code{\link{buildGRUmaps}} function
or two rasters previously created with the initial conditions of the soil water and groundwater storage. If there is only
be one raster found, the function creates those two rasters using the value of the provide raster reduced by half.
}
\examples{
library(raster)

# Example 1
data(gru_maps)
init <- init_state(gru_maps$smaxR)

# Example 2
data(In_storage, In_ground)
init <- init_state(stack(In_storage, In_ground))

}
\references{
Budyko. (1974). "Climate and life". New York: Academic Press, INC.

Zhang, L., Potter, N., Hickel, K., Zhang, Y., & Shao, Q. (2008). 
"Water balance modeling over variable time scales based on the Budyko framework - Model 
development and testing. Journal of Hydrology", 360(1-4), 
117-131.
}
\author{
Nicolas Duque Gardeazabal <nduqueg@unal.edu.co> \cr
Pedro Felipe Arboleda <pfarboledao@unal.edu.co> \cr
Carolina Vega Viviescas <cvegav@unal.edu.co> \cr
David Zamora <dazamoraa@unal.edu.co> \cr

Water Resources Engineering Research Group - GIREH
Universidad Nacional de Colombia - Sede Bogota
}
