% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printVar.R
\name{printVar}
\alias{printVar}
\title{Print or write variables of interest}
\usage{
printVar(variable, coor_cells, var_name, coord_sys, dates, as, path_var = "")
}
\arguments{
\item{variable}{corresponds to the results of a specific variable of the DWBCalculator.}

\item{coor_cells}{coordinates of the cells in the same order that were simulated and that will be used to
create the results in raster format, this is done from the data frames which contain the simulated results}

\item{var_name}{name of the variable that will be printed (e.g., q_total, aet, r, qd, qb, s, g)}

\item{coord_sys}{geographic or projected coordinate system.}

\item{dates}{dates that were simulated.}

\item{as}{option to print the results as independent 'raster' (\emph{\code{.tif}}) or in a 'NetCDF' file (\emph{\code{.nc}}).}

\item{path_var}{path of the directory where one wants to print the files}
}
\value{
It saves in a folder previously created a set of raster files with the results of the 
variable of interest.
}
\description{
This function allows to print or write some of the variables simulated by the DWB model.
}
\examples{
data(sogamoso)
dwb_results <- sogamoso$dwb_results
data(cells)
dates <- seq(as.Date("2001-01-01"), as.Date("2010-12-01"), by="month")
coord_sys <- "+init=epsg:4326"
r <- dwb_results[[3]][,1:20]
printVar(r, cells, var_name = "r", coord_sys, dates, as = "NetCDF", path_var = tempdir())

}
\author{
Carolina Vega Viviescas <cvegav@unal.edu.co>  \cr
Nicolas Duque Gardeazabal <nduqueg@unal.edu.co>  \cr
Pedro Felipe Arboleda Obando <pfarboledao@unal.edu.co>  \cr
David Zamora <dazamoraa@unal.edu.co> \cr

Water Resources Engineering Research Group - GIREH
Universidad Nacional de Colombia - sede Bogota
}
