% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp7.power.R
\name{Chapter07_power}
\alias{Chapter07_power}
\alias{power_z}
\title{Chapter 7 (Power Curve)}
\usage{
power_z(
  x,
  null.value,
  sd,
  n,
  alternative = c("two.sided", "less", "greater"),
  sig.level = 0.05
)
}
\arguments{
\item{x}{\link[base]{numeric} vector, mean parameter(s) \eqn{\mu_1} in the alternative hypothesis}

\item{null.value}{\link[base]{numeric} scalar, mean parameter \eqn{\mu_0} in the null hypothesis}

\item{sd}{\link[base]{numeric} scalar, population standard deviation \eqn{\sigma}}

\item{n}{\link[base]{integer} scalar, sample size \eqn{n}}

\item{alternative}{\link[base]{character} scalar, alternative hypothesis, 
either \code{'two.sided'} (default), \code{'greater'} or \code{'less'}}

\item{sig.level}{\link[base]{numeric} scalar, significance level (i.e., Type-I-error rate), default \eqn{.05}}
}
\value{
\link{power_z} returns a \link{power} object, which is a \link[base]{numeric} vector with attributes
\describe{
\item{\code{x}}{a \link[base]{numeric} vector, alternative parameters \eqn{\mu_1}}
\item{\code{hypothesis}}{a \code{'z_hypothesis'} object, containing information of the null hypothesis,
significance level and rejection region, etc.}
}
A \link[base]{print} method, a \link[ggplot2]{autolayer} and a \link[ggplot2]{autoplot} method are defined for \link{power_z} object.
}
\description{
Functions for Chapter 7, \emph{Hypothesis Testing}.
}
\details{
\link{power_z} calculates the powers at each element of the alternative parameters \eqn{\mu_1}, for one-sample \eqn{z}-test
\itemize{
\item{\eqn{H_0: \mu = \mu_0} vs. \eqn{H_A: \mu \neq \mu_0}, if \code{alternative = 'two.sided'}}
\item{\eqn{H_0: \mu \leq \mu_0} vs. \eqn{H_A: \mu > \mu_0}, if \code{alternative = 'greater'}}
\item{\eqn{H_0: \mu \geq \mu_0} vs. \eqn{H_A: \mu < \mu_0}, if \code{alternative = 'less'}}
}
}
\examples{
library(DanielBiostatistics10th)
# To run a line of code, use shortcut
# Command + Enter: Mac and RStudio Cloud
# Control + Enter: Windows, Mac and RStudio Cloud
# To clear the console
# Control + L: Mac and RStudio Cloud

# To view the help files
# ?Chapter07_power

# Page 272, Example 7.9.1
(p791 = power_z(seq.int(from = 16, to = 19, by = .5), null.value = 17.5, sd = 3.6, n = 100L, 
                alternative = 'two.sided')) # Page 275, Table 7.9.1
autoplot(p791, title = 'Page 275, Figure 7.9.2')

# Page 276, Example 7.9.2
# To mimic the set up of Page 275, Table 7.9.1, calculate the power at c(50, 55, 60, 65)
(p792 = power_z(c(50, 55, 60, 65), null.value = 65, sd = 15, n = 20L, sig.level = .01, 
                alternative = 'less'))
autoplot(p792, title = 'Page 277, Figure 7.9.4')

# Page 278, Example 7.10.1
# Textbook requires Pr(Fail to reject H0) = beta = .05, which is equivalent to power = .95
(n7101 <- uniroot(f = function(x) {
  power_z(55, null.value = 65, sd = 15, n = x, sig.level = .01, alternative = 'less') - .95
}, interval = c(0, 50))$root)
# Why ?stats::power.t.test gives different answer?
power.t.test(delta = abs(55-65), sd = 15, sig.level = .01, power = .95, 
  type = 'one.sample', alternative = 'one.sided')
# Textbook result uses z-test (i.e., population sd is 15)
# while ?stats::power.t.test uses t-test.   
# There is no built in R function to do power analysis based on z-test, 
# because in reality we seldom know the population sd.

# 1-sided vs. 2-sided test
autoplot(p792, all.alternative = TRUE, title = '1-sided vs. 2-sided test')

}
\references{
Wayne W. Daniel, \emph{Biostatistics: A Foundation for Analysis in the Health Sciences}, Tenth Edition.
Wiley, ISBN: 978-1-119-62550-6.
}
\seealso{
\link[stats]{power.t.test}
}
