% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binTab.R
\name{binTab}
\alias{binTab}
\alias{binTab.matrix}
\alias{binTab.table}
\alias{binTab.formula}
\title{Boolean Test-&-Disease or Risk-&-Disease Table}
\usage{
binTab(x, ...)

\method{binTab}{matrix}(x, ...)

\method{binTab}{table}(x, ...)

\method{binTab}{formula}(formula, data, ...)
}
\arguments{
\item{x}{(an R object convertible to a) \eqn{2\times 2} \link[base]{integer} \link[base]{matrix},
contingency table of two Boolean variables.
The endpoint (i.e., disease) is on rows and the test/risk on columns.}

\item{formula}{\link[stats]{formula} in the fashion of \code{~disease+test} or \code{~disease+risk}, see function \link[stats]{xtabs}}

\item{data}{a \link[base]{data.frame}}
}
\value{
Function \link{binTab} returns a two-by-two \link[base]{integer} \link[base]{matrix}.
}
\description{
To create a Boolean test-&-disease or risk-&-disease table.
}
\details{
Function \link{binTab} creates a \eqn{2\times 2} test-&-disease contingency table with layout
\tabular{lcc}{
\tab Test (\eqn{-}) \tab Test (\eqn{+}) \cr
Disease (\eqn{-}) \tab \eqn{x_{--}} \tab \eqn{x_{-+}} \cr
Disease (\eqn{+}) \tab \eqn{x_{+-}} \tab \eqn{x_{++}} \cr
}
or a \eqn{2\times 2} risk-&-disease contingency table with layout
\tabular{lcc}{
\tab Risk Factor (\eqn{-}) \tab Risk Factor (\eqn{+}) \cr
Disease (\eqn{-}) \tab \eqn{x_{--}} \tab \eqn{x_{-+}} \cr
Disease (\eqn{+}) \tab \eqn{x_{+-}} \tab \eqn{x_{++}} \cr
}
The endpoint (i.e., disease) must be on the rows and the test/risk on the columns.
}
\examples{
binTab(matrix(c(7L, 3L, 8L, 6L), nrow = 2L))
binTab(matrix(c(7L, 3L, 8L, 6L), nrow = 2L, dimnames = list(X = c('a','b'), NULL)))
binTab(~ (mag < 4.5) + (depth > 400), data = quakes)
}
\seealso{
Function \code{caret::confusionMatrix} does not provide confidence intervals of
sensitivity, specificity, etc.
}
\keyword{internal}
