% Generated by roxygen2 (4.0.2): do not edit by hand
\name{InsertRow}
\alias{InsertRow}
\title{Inserts a new row into a data frame}
\source{
The function largely implements:
\url{http://stackoverflow.com/a/11562428}
}
\usage{
InsertRow(data, NewRow, RowNum = NULL)
}
\arguments{
\item{data}{a data frame to insert the new row into.}

\item{NewRow}{a vector whose length is the same as the number of columns in
\code{data}.}

\item{RowNum}{numeric indicating which row to insert the new row as. If not
specified then the new row is added to the end using a vanilla
\code{\link{rbind}} call.}
}
\description{
Inserts a new row into a data frame
}
\examples{
# Create dummy data
A <- B <- C <- D <- sample(1:20, size = 20, replace = TRUE)
Data <- data.frame(A, B, C, D)

# Create new row
New <- rep(1000, 4)

# Insert into 4th row
Data <- InsertRow(Data, NewRow = New, RowNum = 4)
}

