% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_edit.R
\name{data_edit}
\alias{data_edit}
\title{An interactive editor for viewing, entering & editing data}
\usage{
data_edit(
  x,
  col_bind = NULL,
  col_edit = TRUE,
  col_options = NULL,
  col_stretch = FALSE,
  col_factor = FALSE,
  col_names = TRUE,
  col_readonly = NULL,
  row_bind = NULL,
  row_edit = TRUE,
  save_as = NULL,
  title = NULL,
  logo = NULL,
  logo_size = 100,
  viewer = TRUE,
  theme = "yeti",
  quiet = FALSE,
  read_fun = "read.csv",
  read_args = NULL,
  write_fun = "write.csv",
  write_args = NULL,
  ...
)
}
\arguments{
\item{x}{a matrix, data.frame, data.table or the name of a csv file to
edit.Tibble are also supported but will be coerced to data.frames. An empty
table can be created by specifying the dimensions in a vector of the form
\code{c(nrow, ncol)}.}

\item{col_bind}{additional columns to add to the data prior to loading into
editor, can be either an array containing the new data, a vector containing
the new column names for empty columns or a named list containing a vector
for each new column.}

\item{col_edit}{logical indicating whether columns can be added or removed,
set to TRUE by default.}

\item{col_options}{named list containing the options for columns that use
dropdown menus or checkboxes.}

\item{col_stretch}{logical indicating whether columns should be stretched to
fill the full width of the display, set to FALSE by default.}

\item{col_factor}{logical indicating whether character columns should be
converted to factors prior to returning the edited data, set to FALSE by
default.}

\item{col_names}{logical indicating whether column names can be edited or a
vector of column names that cannot be edited, set to TRUE by default to
allow editing of column names.}

\item{col_readonly}{names of columns that cannot be edited. Users will be
able to edit values but these will be reverted to the original values.
Column names for these column cannot be edited either.}

\item{row_bind}{additional rows to add to the data prior to loading into
editor, can be either an array containing the new data, a vector containing
the new row names for empty rows or a named list containing a vector for
each new column.}

\item{row_edit}{logical indicating whether rows can be added or removed, set
to TRUE by default.}

\item{save_as}{name of a csv file to which the edited data should be saved.}

\item{title}{optional title to include above the data editor.}

\item{logo}{optional package logo to include in title above the data editor,
must be supplied as path to logo png.}

\item{logo_size}{width of the logo in pixels, set to 100 pixels by default.}

\item{viewer}{logical indicating whether the data editor should be invoked in
the RStudio viewer pane, set to TRUE by default.}

\item{theme}{valid shinytheme name, set to "yeti" by default.}

\item{quiet}{logical indicating whether messages should be suppressed, set to
FALSE by default.}

\item{read_fun}{name of the function to use to read in the data when \code{x}
is the name of a file, set to \code{read.csv} by default.}

\item{read_args}{a named list of additional arguments to pass to
\code{read_fun}.}

\item{write_fun}{name of the function to use to write the edited version of
\code{x} to a file, set to \code{write.csv} by default. Only requirement is
that the first argument accepts the edited data and the second argument
accepts the file name supplied to \code{save_as}.}

\item{write_args}{a named list of additional arguments to pass to
\code{write_fun}.}

\item{...}{additional arguments passed to both \code{read_fun} and
\code{write_fun}, such as \code{sep}. Arguments that are shared by
\code{read_fun} and \code{write_fun} can be supplied separately to these
functions using the \code{read_args} and \code{write_args} arguments. For
example, this becomes particularly important when specifying
\code{row.names} arguments.}
}
\value{
edited matrix-like object.
}
\description{
\code{data_edit} is a shiny application built on \code{rhandsontable} that is
designed to make it easy to interactively view, enter or edit data without
any coding. \code{data_edit} is also a wrapper for any reading or writing
function to make it easy to interactively update data saved to file.
}
\examples{
if (interactive()) {
  # Edit matrix & save to csv
  file <- tempfile("mtcars-new", fileext = ".csv")
  data_edit(mtcars,
    save_as = file
  )

  # Edit csv file
  data_edit(file)
}
}
\author{
Dillon Hammill, \email{Dillon.Hammill@anu.edu.au}
}
