% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotStr.r
\name{PlotStr}
\alias{PlotStr}
\title{Visualize data structure}
\usage{
PlotStr(data, type = c("diagonal", "radial"), max_level,
  print_network = TRUE, ...)
}
\arguments{
\item{data}{input data}

\item{type}{type of network diagram. Defaults to \link{diagonalNetwork}.}

\item{max_level}{integer threshold of nested level to be visualized. Minimum 1 nested level and defaults to all.}

\item{print_network}{logical indicating if network graph should be plotted. Defaults to \code{TRUE}.}

\item{\dots}{other arguments to be passed to plotting functions. See \link{diagonalNetwork} and \link{radialNetwork}.}
}
\value{
input data structure in nested list. Could be transformed to json format with most JSON packages.
}
\description{
Visualize data structures in D3 network graph
}
\examples{
## Visualize structure of iris dataset
PlotStr(iris)

## Visualize object with radial network
PlotStr(rep(list(rep(list(mtcars), 6)), 4), type = "r")

## Generate complicated data object
obj <- list(
  "a" = list(iris, airquality, list(mtcars = mtcars, USArrests = USArrests)),
  "b" = list(list(ts(1:10, frequency = 4))),
  "c" = lm(rnorm(5) ~ seq(5)),
  "d" = lapply(1:5, function(x) return(as.function(function(y) y + 1)))
)
## Visualize data object with diagnal network
PlotStr(obj, type = "d")
## Visualize only top 2 nested levels
PlotStr(obj, type = "d", max_level = 2)
}
\keyword{plotstr}

