% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbSendQuery,DatabaseConnectorJdbcConnection,character-method}
\alias{dbSendQuery,DatabaseConnectorJdbcConnection,character-method}
\title{Execute a query on a given database connection}
\usage{
\S4method{dbSendQuery}{DatabaseConnectorJdbcConnection,character}(conn, statement, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbSendQuery()} returns
an S4 object that inherits from \linkS4class{DBIResult}.
The result set can be used with \code{\link[DBI:dbFetch]{dbFetch()}} to extract records.
Once you have finished using a result, make sure to clear it
with \code{\link[DBI:dbClearResult]{dbClearResult()}}.
An error is raised when issuing a query over a closed
or invalid connection,
or if the query is not a non-\code{NA} string.
An error is also raised if the syntax of the query is invalid
and all query parameters are given (by passing the \code{params} argument)
or the \code{immediate} argument is set to \code{TRUE}.
}
\description{
The \code{dbSendQuery()} method only submits and synchronously executes the
SQL query to the database engine.  It does \emph{not} extract any
records --- for that you need to use the \code{\link[DBI:dbFetch]{dbFetch()}} method, and
then you must call \code{\link[DBI:dbClearResult]{dbClearResult()}} when you finish fetching the
records you need. For interactive use, you should almost always prefer
\code{\link[DBI:dbGetQuery]{dbGetQuery()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbSendQuery")}
}
\details{
This method is for \code{SELECT} queries only.  Some backends may
support data manipulation queries through this method for compatibility
reasons.  However, callers are strongly encouraged to use
\code{\link[DBI:dbSendStatement]{dbSendStatement()}} for data manipulation statements.

The query is submitted to the database server and the DBMS executes it,
possibly generating vast amounts of data. Where these data live
is driver-specific: some drivers may choose to leave the output on the server
and transfer them piecemeal to R, others may transfer all the data to the
client -- but not necessarily to the memory that R manages. See individual
drivers' \code{dbSendQuery()} documentation for details.
}
\seealso{
For updates: \code{\link[DBI:dbSendStatement]{dbSendStatement()}} and \code{\link[DBI:dbExecute]{dbExecute()}}.

Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbWriteTable}()}
}
