/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.databaseConnector;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class BatchedQuery {
    public static int NUMERIC = 1;
    public static int STRING = 2;
    public static int DATE = 3;
    public static int DATETIME = 4;
    public static int INTEGER64 = 5;
    public static int INTEGER = 6;
    public static int FETCH_SIZE = 2048;
    public static double MAX_BATCH_SIZE = 1000000.0;
    public static long CHECK_MEM_ROWS = 10000L;
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String SPARK = "spark";
    private Object[] columns;
    private int[] columnTypes;
    private String[] columnNames;
    private String[] columnSqlTypes;
    private int rowCount;
    private int totalRowCount;
    private int batchSize;
    private ResultSet resultSet;
    private Connection connection;
    private boolean done;
    private ByteBuffer byteBuffer;
    private long availableMemoryAtStart;
    private String dbms;

    private static double[] convertToInteger64ForR(long[] value, ByteBuffer byteBuffer) {
        double[] result = new double[value.length];
        byteBuffer.clear();
        int i = 0;
        while (i < value.length) {
            byteBuffer.putLong(value[i]);
            ++i;
        }
        byteBuffer.flip();
        i = 0;
        while (i < value.length) {
            result[i] = byteBuffer.getDouble();
            ++i;
        }
        return result;
    }

    public static double[] validateInteger64() {
        long[] values = new long[]{1L, -1L, (long)Math.pow(2.0, 33.0), (long)Math.pow(-2.0, 33.0)};
        return BatchedQuery.convertToInteger64ForR(values, ByteBuffer.allocate(8 * values.length));
    }

    public static double getAvailableHeapSpace() {
        return BatchedQuery.getAvailableHeapSpace(true);
    }

    private static long getAvailableHeapSpace(boolean collectGarbage) {
        if (collectGarbage) {
            System.gc();
        }
        return Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    private void reserveMemory() {
        this.availableMemoryAtStart = BatchedQuery.getAvailableHeapSpace(true);
        int bytesPerRow = 0;
        int columnIndex = 0;
        while (columnIndex < this.columnTypes.length) {
            bytesPerRow = this.columnTypes[columnIndex] == NUMERIC ? (bytesPerRow += 8) : (this.columnTypes[columnIndex] == INTEGER ? (bytesPerRow += 4) : (this.columnTypes[columnIndex] == INTEGER64 ? (bytesPerRow += 16) : (this.columnTypes[columnIndex] == STRING ? (bytesPerRow += 512) : (bytesPerRow += 24))));
            ++columnIndex;
        }
        this.batchSize = (int)Math.min(MAX_BATCH_SIZE, (double)Math.round((double)this.availableMemoryAtStart / 10.0 / (double)bytesPerRow));
        this.columns = new Object[this.columnTypes.length];
        columnIndex = 0;
        while (columnIndex < this.columnTypes.length) {
            this.columns[columnIndex] = this.columnTypes[columnIndex] == NUMERIC ? (Object)new double[this.batchSize] : (this.columnTypes[columnIndex] == INTEGER ? (Object)new int[this.batchSize] : (this.columnTypes[columnIndex] == INTEGER64 ? (Object)new long[this.batchSize] : (this.columnTypes[columnIndex] == STRING ? new String[this.batchSize] : new String[this.batchSize])));
            ++columnIndex;
        }
        this.byteBuffer = ByteBuffer.allocate(8 * this.batchSize);
        this.rowCount = 0;
    }

    private void cleanUpStrings() {
        int columnIndex = 0;
        while (columnIndex < this.columns.length) {
            if (this.columnTypes[columnIndex] == STRING) {
                String[] column = (String[])this.columns[columnIndex];
                int i = 0;
                while (i < column.length) {
                    column[i] = null;
                    ++i;
                }
            }
            ++columnIndex;
        }
    }

    private void trySettingAutoCommit(boolean value) throws SQLException {
        if (this.dbms.equals(SPARK)) {
            return;
        }
        try {
            this.connection.setAutoCommit(value);
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public BatchedQuery(Connection connection, String query, String dbms) throws SQLException {
        this.connection = connection;
        this.dbms = dbms;
        this.trySettingAutoCommit(false);
        Statement statement = connection.createStatement(1003, 1007);
        statement.setFetchSize(FETCH_SIZE);
        this.resultSet = statement.executeQuery(query);
        this.resultSet.setFetchSize(FETCH_SIZE);
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        this.columnTypes = new int[metaData.getColumnCount()];
        this.columnSqlTypes = new String[metaData.getColumnCount()];
        int columnIndex = 0;
        while (columnIndex < metaData.getColumnCount()) {
            this.columnSqlTypes[columnIndex] = metaData.getColumnTypeName(columnIndex + 1);
            int type = metaData.getColumnType(columnIndex + 1);
            String className = metaData.getColumnClassName(columnIndex + 1);
            int precision = metaData.getPrecision(columnIndex + 1);
            int scale = metaData.getScale(columnIndex + 1);
            this.columnTypes[columnIndex] = type == 4 || type == 5 || type == -6 || dbms.equals("oracle") && className.equals("java.math.BigDecimal") && precision > 0 && precision != 19 && scale == 0 ? INTEGER : (type == -5 || dbms.equals("oracle") && className.equals("java.math.BigDecimal") && precision > 0 && scale == 0 ? INTEGER64 : (type == 3 || type == 8 || type == 6 || type == 2 || type == 7 ? NUMERIC : (type == 91 ? DATE : (type == 93 ? DATETIME : STRING))));
            ++columnIndex;
        }
        this.columnNames = new String[metaData.getColumnCount()];
        columnIndex = 0;
        while (columnIndex < metaData.getColumnCount()) {
            this.columnNames[columnIndex] = metaData.getColumnLabel(columnIndex + 1);
            ++columnIndex;
        }
        this.reserveMemory();
        this.done = false;
        this.totalRowCount = 0;
    }

    public void fetchBatch() throws SQLException {
        this.cleanUpStrings();
        this.rowCount = 0;
        while (this.rowCount < this.batchSize) {
            if (this.resultSet.next()) {
                int columnIndex = 0;
                while (columnIndex < this.columnTypes.length) {
                    if (this.columnTypes[columnIndex] == NUMERIC) {
                        ((double[])this.columns[columnIndex])[this.rowCount] = this.resultSet.getDouble(columnIndex + 1);
                        if (this.resultSet.wasNull()) {
                            ((double[])this.columns[columnIndex])[this.rowCount] = Double.NaN;
                        }
                    } else if (this.columnTypes[columnIndex] == INTEGER64) {
                        ((long[])this.columns[columnIndex])[this.rowCount] = this.resultSet.getLong(columnIndex + 1);
                        if (this.resultSet.wasNull()) {
                            ((long[])this.columns[columnIndex])[this.rowCount] = Long.MIN_VALUE;
                        }
                    } else if (this.columnTypes[columnIndex] == INTEGER) {
                        ((int[])this.columns[columnIndex])[this.rowCount] = this.resultSet.getInt(columnIndex + 1);
                        if (this.resultSet.wasNull()) {
                            ((int[])this.columns[columnIndex])[this.rowCount] = Integer.MIN_VALUE;
                        }
                    } else {
                        Timestamp timestamp;
                        Date date;
                        ((String[])this.columns[columnIndex])[this.rowCount] = this.columnTypes[columnIndex] == STRING ? this.resultSet.getString(columnIndex + 1) : (this.columnTypes[columnIndex] == DATE ? ((date = this.resultSet.getDate(columnIndex + 1)) == null ? null : DATE_FORMAT.format(date)) : ((timestamp = this.resultSet.getTimestamp(columnIndex + 1)) == null ? null : DATETIME_FORMAT.format(timestamp)));
                    }
                    ++columnIndex;
                }
                ++this.rowCount;
                if ((long)this.rowCount % CHECK_MEM_ROWS != 0L || BatchedQuery.getAvailableHeapSpace(false) >= this.availableMemoryAtStart / 2L || BatchedQuery.getAvailableHeapSpace(true) >= this.availableMemoryAtStart / 2L) continue;
                break;
            }
            this.done = true;
            this.trySettingAutoCommit(true);
            break;
        }
        this.totalRowCount += this.rowCount;
    }

    public void clear() {
        try {
            this.resultSet.close();
            this.columns = null;
            this.byteBuffer = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public double[] getNumeric(int columnIndex) {
        double[] column = (double[])this.columns[columnIndex - 1];
        if (column.length > this.rowCount) {
            double[] newColumn = new double[this.rowCount];
            System.arraycopy(column, 0, newColumn, 0, this.rowCount);
            return newColumn;
        }
        return column;
    }

    public String[] getString(int columnIndex) {
        String[] column = (String[])this.columns[columnIndex - 1];
        if (column.length > this.rowCount) {
            String[] newColumn = new String[this.rowCount];
            System.arraycopy(column, 0, newColumn, 0, this.rowCount);
            return newColumn;
        }
        return column;
    }

    public int[] getInteger(int columnIndex) {
        int[] column = (int[])this.columns[columnIndex - 1];
        if (column.length > this.rowCount) {
            int[] newColumn = new int[this.rowCount];
            System.arraycopy(column, 0, newColumn, 0, this.rowCount);
            return newColumn;
        }
        return column;
    }

    public double[] getInteger64(int columnIndex) {
        long[] column = (long[])this.columns[columnIndex - 1];
        if (column.length > this.rowCount) {
            long[] newColumn = new long[this.rowCount];
            System.arraycopy(column, 0, newColumn, 0, this.rowCount);
            return BatchedQuery.convertToInteger64ForR(newColumn, this.byteBuffer);
        }
        return BatchedQuery.convertToInteger64ForR(column, this.byteBuffer);
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isEmpty() {
        return this.rowCount == 0;
    }

    public int[] getColumnTypes() {
        return this.columnTypes;
    }

    public String[] getColumnSqlTypes() {
        return this.columnSqlTypes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int getTotalRowCount() {
        return this.totalRowCount;
    }
}

