/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.cmdlineverification;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.BigqueryRequest;
import com.google.api.services.bigquery.BigqueryRequestInitializer;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.starschema.clouddb.cmdlineverification.BQXMLCredentialStore;
import net.starschema.clouddb.cmdlineverification.CmdlineUtils;
import net.starschema.clouddb.cmdlineverification.LocalServerReceiver;
import net.starschema.clouddb.cmdlineverification.VerificationCodeReceiver;
import net.starschema.clouddb.jdbc.Logger;
import org.apache.commons.io.FileUtils;

public class Oauth2Bigquery {
    private static String servicepath = null;
    static Logger logger = Logger.getLogger(Oauth2Bigquery.class.getName());
    static final String[] browsers = new String[]{"google-chrome", "firefox", "opera", "epiphany", "konqueror", "conkeror", "midori", "kazehakase", "mozilla"};
    private static GoogleClientSecrets clientSecrets = null;
    public static GoogleAuthorizationCodeFlow codeflow = null;
    private static String PathForXmlStore = System.getProperty("user.home") + File.separator + ".bqjdbc" + File.separator + "xmllocation.properties";
    private static final String DRIVE_SCOPE = "https://www.googleapis.com/auth/drive";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Credential authorize(HttpTransport transport, JsonFactory jsonFactory, VerificationCodeReceiver receiver, List<String> scopes, String clientid, String clientsecret) throws Exception {
        BQXMLCredentialStore Store = new BQXMLCredentialStore(PathForXmlStore);
        GoogleClientSecrets.Details details = new GoogleClientSecrets.Details();
        details.setClientId(clientid);
        details.setClientSecret(clientsecret);
        details.set("Factory", CmdlineUtils.getJsonFactory());
        details.setAuthUri("https://accounts.google.com/o/oauth2/auth");
        details.setTokenUri("https://accounts.google.com/o/oauth2/token");
        GoogleClientSecrets secr = new GoogleClientSecrets().setInstalled(details);
        GoogleCredential CredentialForReturn = new GoogleCredential.Builder().setJsonFactory(CmdlineUtils.getJsonFactory()).setTransport(CmdlineUtils.getHttpTransport()).setClientSecrets(secr).build();
        if (Store.load(clientid + ":" + clientsecret, CredentialForReturn)) {
            return CredentialForReturn;
        }
        try {
            String redirectUri = receiver.getRedirectUri();
            GoogleClientSecrets clientSecrets = Oauth2Bigquery.loadClientSecrets(jsonFactory, clientid, clientsecret);
            codeflow = new GoogleAuthorizationCodeFlow.Builder(transport, jsonFactory, clientSecrets, scopes).setAccessType("offline").setApprovalPrompt("auto").setCredentialStore(Store).build();
            Oauth2Bigquery.browse(codeflow.newAuthorizationUrl().setRedirectUri(redirectUri).build());
            String code = receiver.waitForCode();
            GoogleTokenResponse response = codeflow.newTokenRequest(code).setRedirectUri(redirectUri).execute();
            Credential credential = codeflow.createAndStoreCredential(response, clientid + ":" + clientsecret);
            return credential;
        }
        finally {
            receiver.stop();
        }
    }

    public static Bigquery authorizeviainstalled(String clientid, String clientsecret, String userAgent) throws SQLException {
        LocalServerReceiver rcvr = new LocalServerReceiver();
        ArrayList<String> Scopes = new ArrayList<String>();
        Scopes.add("https://www.googleapis.com/auth/bigquery");
        Credential credential = null;
        try {
            logger.debug("Authorizing as installed app.");
            credential = Oauth2Bigquery.authorize(CmdlineUtils.getHttpTransport(), CmdlineUtils.getJsonFactory(), rcvr, Scopes, clientid, clientsecret);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        logger.debug("Creating a new bigquery client.");
        Bigquery.Builder bqBuilder = new Bigquery.Builder(CmdlineUtils.getHttpTransport(), CmdlineUtils.getJsonFactory(), credential);
        if (userAgent != null) {
            BigQueryRequestUserAgentInitializer requestInitializer = new BigQueryRequestUserAgentInitializer();
            requestInitializer.setUserAgent(userAgent);
            bqBuilder.setBigqueryRequestInitializer(requestInitializer);
        }
        Bigquery bigquery = bqBuilder.build();
        servicepath = bigquery.getServicePath();
        return bigquery;
    }

    public static Bigquery authorizeviadefaultcredentials() throws SQLException {
        GoogleCredential credential = null;
        try {
            credential = GoogleCredential.getApplicationDefault();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        logger.debug("Creating a new bigquery client.");
        Bigquery.Builder bqBuilder = new Bigquery.Builder(CmdlineUtils.getHttpTransport(), CmdlineUtils.getJsonFactory(), credential);
        Bigquery bigquery = bqBuilder.build();
        servicepath = bigquery.getServicePath();
        return bigquery;
    }

    private static GoogleCredential createP12Credential(String serviceaccountemail, String keypath, String password) throws GeneralSecurityException, IOException {
        logger.debug("Authorizing with service account.");
        GoogleCredential.Builder builder = new GoogleCredential.Builder().setTransport(CmdlineUtils.getHttpTransport()).setJsonFactory(CmdlineUtils.getJsonFactory()).setServiceAccountId(serviceaccountemail).setServiceAccountScopes(Oauth2Bigquery.GenerateScopes());
        if (password == null) {
            builder = builder.setServiceAccountPrivateKeyFromP12File(new File(keypath));
        } else {
            PrivateKey pk = Oauth2Bigquery.getPrivateKeyFromCredentials(keypath, password);
            builder = builder.setServiceAccountPrivateKey(pk);
        }
        return builder.build();
    }

    private static GoogleCredential createJsonCredential(String keypath) throws GeneralSecurityException, IOException {
        logger.debug("Authorizing with service account.");
        File jsonKey = new File(keypath);
        FileInputStream inputStream = new FileInputStream(jsonKey);
        return GoogleCredential.fromStream(inputStream, CmdlineUtils.getHttpTransport(), CmdlineUtils.getJsonFactory()).createScoped(Oauth2Bigquery.GenerateScopes());
    }

    public static Bigquery authorizeviaservice(String serviceaccountemail, String keypath, String password, String userAgent, Integer connectTimeout, Integer readTimeout) throws GeneralSecurityException, IOException {
        GoogleCredential credential = Pattern.matches(".*\\.json$", keypath) ? Oauth2Bigquery.createJsonCredential(keypath) : Oauth2Bigquery.createP12Credential(serviceaccountemail, keypath, password);
        logger.debug("Authorizied?");
        HttpRequestTimeoutInitializer httpRequestInitializer = new HttpRequestTimeoutInitializer(credential);
        if (connectTimeout != null) {
            httpRequestInitializer.setConnectTimeout(connectTimeout);
        }
        if (readTimeout != null) {
            httpRequestInitializer.setReadTimeout(readTimeout);
        }
        Bigquery.Builder bqBuilder = new Bigquery.Builder(CmdlineUtils.getHttpTransport(), CmdlineUtils.getJsonFactory(), httpRequestInitializer).setApplicationName("Starschema BigQuery JDBC Driver");
        if (userAgent != null) {
            BigQueryRequestUserAgentInitializer requestInitializer = new BigQueryRequestUserAgentInitializer();
            requestInitializer.setUserAgent(userAgent);
            bqBuilder.setBigqueryRequestInitializer(requestInitializer);
        }
        Bigquery bigquery = bqBuilder.build();
        servicepath = bigquery.getServicePath();
        return bigquery;
    }

    private static List<String> GenerateScopes() {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://www.googleapis.com/auth/bigquery");
        scopes.add(DRIVE_SCOPE);
        return scopes;
    }

    private static PrivateKey getPrivateKeyFromCredentials(String keyPath, String password) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        byte[] bytes = FileUtils.readFileToByteArray(new File(keyPath));
        keystore.load(new ByteArrayInputStream(bytes), password.toCharArray());
        return (PrivateKey)keystore.getKey(keystore.aliases().nextElement(), password.toCharArray());
    }

    private static void browse(String url) {
        Desktop desktop;
        logger.debug("First try the Java Desktop");
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(URI.create(url));
                logger.debug("success");
                return;
            }
            catch (IOException e) {
                logger.debug("Failed with desktop.browse", e);
            }
        }
        logger.debug("Try with browsers");
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                logger.debug("Mac OS com.apple.eio.FileManager should handle the URL");
                Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                return;
            }
            if (osName.startsWith("Windows")) {
                logger.debug("Let's run internet suxplorer! with the URL: " + url);
                Runtime.getRuntime().exec("cmd.exe /c start iexplore.exe \"" + url + "\"");
                return;
            }
            logger.debug("Unix or Linux, we'll open a browser");
            String browser = null;
            for (String b : browsers) {
                if (browser != null || Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() == -1) continue;
                Runtime.getRuntime().exec(new String[]{browser = b, url});
            }
        }
        catch (Exception e) {
            logger.debug("Failed", e);
        }
        logger.debug("Then try with url.connect");
        try {
            URL myURL = new URL(url);
            URLConnection myURLConnection = myURL.openConnection();
            myURLConnection.connect();
            logger.debug("success");
            return;
        }
        catch (Exception e) {
            logger.debug(null, e);
            System.out.println("Please open the following URL in your browser:");
            System.out.println("  " + url);
            System.err.println("Please open the following URL in your browser:");
            System.err.println("  " + url);
            return;
        }
    }

    public static GoogleClientSecrets getClientSecrets() {
        return clientSecrets;
    }

    public static String getservicepath() {
        return servicepath;
    }

    private static GoogleClientSecrets loadClientSecrets(JsonFactory jsonFactory, String clientid, String clientsecret) throws IOException {
        if (clientSecrets == null) {
            String clientsecrets = "{\n\"installed\": {\n\"client_id\": \"" + clientid + "\",\n\"client_secret\":\"" + clientsecret + "\",\n\"redirect_uris\": [\"http://localhost\", \"urn:ietf:oauth:2.0:oob\"],\n\"auth_uri\": \"https://accounts.google.com/o/oauth2/auth\",\n\"token_uri\": \"https://accounts.google.com/o/oauth2/token\"\n}\n}";
            StringReader stringReader = new StringReader(clientsecrets);
            clientSecrets = GoogleClientSecrets.load(jsonFactory, stringReader);
        }
        return clientSecrets;
    }

    private static class BigQueryRequestUserAgentInitializer
    extends BigqueryRequestInitializer {
        String userAgent = null;

        private BigQueryRequestUserAgentInitializer() {
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        @Override
        public void initializeBigqueryRequest(BigqueryRequest<?> request) throws IOException {
            if (this.userAgent != null) {
                HttpHeaders currentHeaders = request.getRequestHeaders();
                currentHeaders.setUserAgent(this.userAgent);
                request.setRequestHeaders(currentHeaders);
            }
        }
    }

    private static class HttpRequestTimeoutInitializer
    implements HttpRequestInitializer {
        private Integer readTimeout = null;
        private Integer connectTimeout = null;
        private GoogleCredential credential = null;

        public HttpRequestTimeoutInitializer(GoogleCredential credential) {
            this.credential = credential;
        }

        public void setCredential(GoogleCredential credential) {
            this.credential = credential;
        }

        public void setReadTimeout(Integer timeout) {
            this.readTimeout = timeout;
        }

        public void setConnectTimeout(Integer timeout) {
            this.connectTimeout = timeout;
        }

        @Override
        public void initialize(HttpRequest httpRequest) throws IOException {
            this.credential.initialize(httpRequest);
            if (this.connectTimeout != null) {
                httpRequest.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout != null) {
                httpRequest.setReadTimeout(this.readTimeout);
            }
        }
    }
}

