/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import com.google.api.services.bigquery.Bigquery;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.starschema.clouddb.cmdlineverification.Oauth2Bigquery;
import net.starschema.clouddb.jdbc.BQDatabaseMetadata;
import net.starschema.clouddb.jdbc.BQPreparedStatement;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.BQStatement;
import net.starschema.clouddb.jdbc.BQStatementRoot;
import net.starschema.clouddb.jdbc.BQSupportFuncts;
import net.starschema.clouddb.jdbc.Logger;

public class BQConnection
implements Connection {
    private boolean autoCommitEnabled = false;
    Logger logger;
    private Bigquery bigquery = null;
    private String dataset = null;
    private String projectId = null;
    private boolean isclosed = false;
    private Long maxBillingBytes;
    private final Set<BQStatementRoot> runningStatements = Collections.synchronizedSet(new HashSet());
    private boolean transformQuery = false;
    private boolean useLegacySql = false;
    private List<SQLWarning> SQLWarningList = new ArrayList<SQLWarning>();
    private String URLPART = null;

    public boolean getTransformQuery() {
        return this.transformQuery;
    }

    public boolean getUseLegacySql() {
        return this.useLegacySql;
    }

    public BQConnection(String url, Properties loginProp) throws SQLException {
        String maxBillingBytesParam;
        Properties caseInsensitiveProps;
        this.logger = Logger.getLogger(this.getClass());
        this.URLPART = url;
        this.isclosed = false;
        try {
            int endPathIndex = url.indexOf(63);
            if (endPathIndex == -1) {
                endPathIndex = url.length();
            }
            String pathParams = URLDecoder.decode(url.substring(url.lastIndexOf(":") + 1, endPathIndex), "UTF-8");
            Pattern pattern = Pattern.compile("^([^/$]+)(?:/([^$]*))?$");
            Matcher matchData = pattern.matcher(pathParams);
            if (matchData.find()) {
                this.projectId = matchData.group(1);
                this.dataset = matchData.group(2);
            } else {
                this.projectId = pathParams;
            }
        }
        catch (UnsupportedEncodingException e1) {
            throw new BQSQLException(e1);
        }
        this.projectId = this.projectId.replace(":", "__").replace(".", "_");
        Properties caseInsensitiveLoginProps = new Properties();
        if (loginProp != null) {
            for (String string : loginProp.keySet()) {
                caseInsensitiveLoginProps.setProperty(string.toLowerCase(), loginProp.getProperty(string));
            }
        }
        try {
            caseInsensitiveProps = BQSupportFuncts.getUrlQueryComponents(url, caseInsensitiveLoginProps);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BQSQLException(unsupportedEncodingException);
        }
        String string = caseInsensitiveProps.getProperty("user");
        String userKey = caseInsensitiveProps.getProperty("password");
        String userPath = caseInsensitiveProps.getProperty("path");
        String withServiceAccountParam = caseInsensitiveProps.getProperty("withserviceaccount");
        Boolean serviceAccount = withServiceAccountParam != null && Boolean.parseBoolean(withServiceAccountParam);
        String transformQueryParam = caseInsensitiveProps.getProperty("transformquery");
        this.transformQuery = transformQueryParam != null && Boolean.parseBoolean(transformQueryParam);
        String legacySqlParam = caseInsensitiveProps.getProperty("uselegacysql");
        this.useLegacySql = legacySqlParam != null && Boolean.parseBoolean(legacySqlParam);
        String readTimeoutString = caseInsensitiveProps.getProperty("readtimeout");
        Integer readTimeout = null;
        if (readTimeoutString != null) {
            try {
                readTimeout = Integer.parseInt(readTimeoutString);
                if (readTimeout < 0) {
                    throw new BQSQLException("readTimeout must be positive.");
                }
            }
            catch (NumberFormatException e) {
                throw new BQSQLException("could not parse readTimeout parameter.", e);
            }
        }
        String connectTimeoutString = caseInsensitiveProps.getProperty("connecttimeout");
        Integer connectTimeout = null;
        if (connectTimeoutString != null) {
            try {
                connectTimeout = Integer.parseInt(connectTimeoutString);
                if (connectTimeout < 0) {
                    throw new BQSQLException("connectTimeout must be positive.");
                }
            }
            catch (NumberFormatException e) {
                throw new BQSQLException("could not parse connectTimeout parameter.", e);
            }
        }
        if ((maxBillingBytesParam = caseInsensitiveProps.getProperty("maxbillingbytes")) != null) {
            try {
                this.maxBillingBytes = Long.parseLong(maxBillingBytesParam);
            }
            catch (NumberFormatException e) {
                throw new BQSQLException("Bad number for maxBillingBytes", e);
            }
        }
        String userAgent = caseInsensitiveProps.getProperty("useragent");
        if (serviceAccount.booleanValue()) {
            try {
                this.logger.info("Authorizing with service account");
                if (userPath == null) {
                    userPath = userKey;
                    userKey = null;
                }
                this.bigquery = Oauth2Bigquery.authorizeviaservice(string, userPath, userKey, userAgent, connectTimeout, readTimeout);
            }
            catch (GeneralSecurityException e) {
                throw new BQSQLException(e);
            }
            catch (IOException e) {
                throw new BQSQLException(e);
            }
        } else if (!(string != null && string.length() != 0 || userKey != null && userKey.length() != 0 || userAgent != null && userAgent.length() != 0)) {
            this.logger.info("Authorizing with default credentials");
            this.bigquery = Oauth2Bigquery.authorizeviadefaultcredentials();
        } else {
            this.logger.info("Authorized with Oauth");
            this.bigquery = Oauth2Bigquery.authorizeviainstalled(string, userKey, userAgent);
        }
        this.logger.debug("The project id for this connections is: " + this.projectId);
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isclosed) {
            throw new BQSQLException("Connection is closed.");
        }
        this.SQLWarningList.clear();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isclosed) {
            this.cancelRunningQueries();
            this.bigquery = null;
            this.isclosed = true;
        }
    }

    public String getDataSet() {
        return this.dataset;
    }

    @Override
    public void commit() throws SQLException {
        this.logger.debug("BQConnection::commit skipping unsupported function");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.logger.debug("BQConnection::createArrayOf not implemented");
        throw new BQSQLException("Not implemented.createArrayOf(String typeName, Object[] elements)");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.logger.debug("BQConnection::createBlob not implemented");
        throw new BQSQLException("Not implemented.createBlob()");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.logger.debug("BQConnection::createClob not implemented");
        throw new BQSQLException("Not implemented.createClob()");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.logger.debug("BQConnection::createNClob not implemented");
        throw new BQSQLException("Not implemented.createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.logger.debug("BQConnection::createSQLXML not implemented");
        throw new BQSQLException("Not implemented.createSQLXML()");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isclosed) {
            throw new BQSQLException("Connection is closed.");
        }
        this.logger.debug("Creating statement with resultsettype: forward only, concurrency: read only");
        return new BQStatement(this.projectId, this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Connection is Closed");
        }
        this.logger.debug("Creating statement with resultsettype: " + resultSetType + " concurrency: " + resultSetConcurrency);
        return new BQStatement(this.projectId, this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new BQSQLException("Not implemented.createStaement(int,int,int)");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.logger.debug("BQConnection::createStruct not implemented");
        throw new BQSQLException("Not implemented.createStruct(string,object[])");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.logger.debug("BQConnection::setSchema not implemented");
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public String getSchema() throws SQLException {
        return this.dataset;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.logger.debug("BQConnection::abort not implemented");
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.logger.debug("BQConnection::setNetworkTimeout not implemented");
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.logger.debug("BQConnection::getNetworkTimeout not implemented");
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommitEnabled;
    }

    public Bigquery getBigquery() {
        return this.bigquery;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.logger.debug("function call getCatalog returning projectId: " + this.projectId);
        return this.projectId;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.logger.debug("BQConnection::getClientInfo not implemented");
        throw new BQSQLException("Not implemented.getClientInfo()");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.logger.debug("BQConnection::getClientInfo not implemented");
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        BQDatabaseMetadata metadata = new BQDatabaseMetadata(this);
        return metadata;
    }

    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.logger.debug("BQConnection::getTypeMap not implemented");
        throw new BQSQLException("Not implemented.getTypeMap()");
    }

    public String getURLPART() {
        return this.URLPART;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isclosed) {
            throw new BQSQLException("Connection is closed.");
        }
        if (this.SQLWarningList.isEmpty()) {
            return null;
        }
        SQLWarning forreturn = this.SQLWarningList.get(0);
        this.SQLWarningList.remove(0);
        if (!this.SQLWarningList.isEmpty()) {
            for (SQLWarning warning : this.SQLWarningList) {
                forreturn.setNextWarning(warning);
            }
        }
        return forreturn;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isclosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.isclosed) {
            return false;
        }
        if (timeout < 0) {
            throw new BQSQLException("Timeout value can't be negative. ie. it must be 0 or above; timeout value is: " + String.valueOf(timeout));
        }
        try {
            this.bigquery.datasets().list(this.projectId.replace("__", ":").replace("_", ".")).execute();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        this.logger.debug("BQConnection::isWrapperFor not implemented");
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.logger.debug("Function called nativeSQL() " + sql);
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.logger.debug("BQConnection::prepareCall not implemented");
        throw new BQSQLException("Not implemented.prepareCall(string)");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.logger.debug("BQConnection::prepareCall not implemented");
        throw new BQSQLException("Not implemented.prepareCall(String,int,int)");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.logger.debug("BQConnection::prepareCall not implemented");
        throw new BQSQLException("Not implemented.prepareCall(string,int,int,int)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.logger.debug("Creating Prepared Statement project id is: " + this.projectId + " with parameters:");
        this.logger.debug(sql);
        BQPreparedStatement stm = new BQPreparedStatement(sql, this.projectId, this);
        return stm;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.prepareStatement(sql);
        }
        this.logger.debug("BQConnection::prepareStatement not implemented");
        throw new BQSQLException("Not implemented.prepareStatement(string,int)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.logger.debug("Creating Prepared Statement project id is: " + this.projectId + ", resultSetType (int) is: " + String.valueOf(resultSetType) + ", resultSetConcurrency (int) is: " + String.valueOf(resultSetConcurrency) + " with parameters:");
        this.logger.debug(sql);
        BQPreparedStatement stm = new BQPreparedStatement(sql, this.projectId, this, resultSetType, resultSetConcurrency);
        return stm;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.logger.debug("BQConnection::prepareStatement not implemented");
        throw new BQSQLException("Not implemented.prepareStatement(String,int,int,int)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.logger.debug("BQConnection::prepareStatement not implemented");
        throw new BQSQLException("Not implemented.prepareStatement(String,int[])");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.logger.debug("BQConnection::prepareStatement not implemented");
        throw new BQSQLException("Not implemented.prepareStatement(String,String[])");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.logger.debug("BQConnection::releaseSavepoint not implemented");
        throw new BQSQLException("Not implemented.releaseSavepoint(Savepoint)");
    }

    @Override
    public void rollback() throws SQLException {
        this.logger.debug("BQConnection::rollback skipping unimplemented function");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.logger.debug("BQConnection::rollback(savepoint) skipping unimplemented function");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommitEnabled = autoCommit;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.logger.debug("BQConnection::setCatalog not implemented");
        throw new BQSQLException("Not implemented.setCatalog(catalog)");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.logger.debug("BQConnection::setClientInfo not implemented");
        SQLClientInfoException e = new SQLClientInfoException();
        e.setNextException(new BQSQLException("Not implemented. setClientInfo(properties)"));
        throw e;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.logger.debug("BQConnection::setCatalog not implemented");
        SQLClientInfoException e = new SQLClientInfoException();
        e.setNextException(new BQSQLException("Not implemented. setClientInfo(properties)"));
        throw e;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.logger.debug("BQConnection::setHoldability not implemented");
        if (this.isclosed) {
            throw new BQSQLException("Connection is closed.");
        }
        throw new BQSQLException("Not implemented.setHoldability(int)");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Connection is Closed");
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.logger.debug("BQConnection::setSavepoint not implemented");
        throw new BQSQLException("Not implemented.setSavepoint()");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.logger.debug("BQConnection::setSavepoint not implemented");
        throw new BQSQLException("Not implemented.setSavepoint(String)");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.logger.error("skipping unimplemented function BQConnection::setTransactionIsolation");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.logger.debug("BQConnection::setTypeMap not implemented");
        throw new BQSQLException("Not implemented.setTypeMap(Map<String, Class<?>>");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        this.logger.debug("BQConnection::unwrap not implemented");
        throw new BQSQLException("Not found");
    }

    public void addRunningStatement(BQStatementRoot stmt) {
        this.runningStatements.add(stmt);
    }

    public void removeRunningStatement(BQStatementRoot stmt) {
        this.runningStatements.remove(stmt);
    }

    public int getNumberRunningQueries() {
        return this.runningStatements.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelRunningQueries() {
        int numFailed = 0;
        Set<BQStatementRoot> set = this.runningStatements;
        synchronized (set) {
            for (BQStatementRoot stmt : this.runningStatements) {
                try {
                    stmt.cancel();
                }
                catch (SQLException e) {
                    ++numFailed;
                }
            }
        }
        return numFailed;
    }

    public Long getMaxBillingBytes() {
        return this.maxBillingBytes;
    }
}

