/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.Logger;

class BQResultsetMetaData
implements ResultSetMetaData {
    GetQueryResultsResponse result = null;
    ResultSet results = null;
    Logger logger = Logger.getLogger(BQResultsetMetaData.class.getName());

    public BQResultsetMetaData(GetQueryResultsResponse result) {
        this.result = result;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.logger.debug("function call getCatalogName() return is: " + this.result.getJobReference().getProjectId());
        return this.result.getJobReference().getProjectId();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.logger.debug("Function call getcolumnclassname(" + column + ")");
        String Columntype = null;
        try {
            Columntype = this.result.getSchema().getFields().get(column - 1).getType();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BQSQLException(e);
        }
        catch (NullPointerException e) {
            throw new BQSQLException(e);
        }
        if (Columntype.equals("FLOAT")) {
            return Double.class.getName();
        }
        if (Columntype.equals("BOOLEAN")) {
            return Boolean.class.getName();
        }
        if (Columntype.equals("INTEGER")) {
            return Long.class.getName();
        }
        if (Columntype.equals("STRING")) {
            return String.class.getName();
        }
        if (Columntype.equals("TIMESTAMP")) {
            return Timestamp.class.getName();
        }
        throw new BQSQLException("Unsupported Type: " + Columntype);
    }

    @Override
    public int getColumnCount() throws SQLException {
        TableSchema schema = this.result.getSchema();
        List<TableFieldSchema> schemafieldlist = null;
        if (schema == null) {
            return 0;
        }
        schemafieldlist = schema.getFields();
        if (schemafieldlist != null) {
            return this.result.getSchema().getFields().size();
        }
        return 0;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 65536;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (this.getColumnCount() == 0) {
            throw new IndexOutOfBoundsException();
        }
        try {
            return this.result.getSchema().getFields().get(column - 1).getName();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (this.getColumnCount() == 0) {
            throw new BQSQLException("getColumnName(int)", new IndexOutOfBoundsException());
        }
        try {
            return this.result.getSchema().getFields().get(column - 1).getName();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BQSQLException("getColumnName(int)", e);
        }
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (this.getColumnCount() == 0) {
            return 0;
        }
        String Columntype = "";
        try {
            Columntype = this.result.getSchema().getFields().get(column - 1).getType();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BQSQLException("getColumnType(int)", e);
        }
        if (Columntype.equals("FLOAT")) {
            return 8;
        }
        if (Columntype.equals("BOOLEAN")) {
            return 16;
        }
        if (Columntype.equals("INTEGER")) {
            return -5;
        }
        if (Columntype.equals("STRING")) {
            return 12;
        }
        if (Columntype.equals("TIMESTAMP")) {
            return 93;
        }
        throw new BQSQLException("Unsupported Type: " + Columntype);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (this.getColumnCount() == 0) {
            throw new BQSQLException("getcolumnTypeName(int)", new IndexOutOfBoundsException());
        }
        String Columntype = "";
        try {
            Columntype = this.result.getSchema().getFields().get(column - 1).getType();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BQSQLException("getColumnTypeName(int)", e);
        }
        return Columntype;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        if (this.getColumnCount() == 0) {
            return 0;
        }
        String Columntype = "";
        try {
            Columntype = this.result.getSchema().getFields().get(column - 1).getType();
        }
        catch (IndexOutOfBoundsException e) {
            throw new BQSQLException("getPrecision(int)", e);
        }
        if (Columntype.equals("FLOAT")) {
            return 127;
        }
        if (Columntype.equals("BOOLEAN")) {
            return 1;
        }
        if (Columntype.equals("INTEGER")) {
            return 64;
        }
        if (Columntype.equals("STRING")) {
            return 65536;
        }
        if (Columntype.equals("TIMESTAMP")) {
            return 50;
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (this.getColumnType(column) == 8) {
            int max = 0;
            for (int i = 0; i < this.result.getRows().size(); ++i) {
                int pointback;
                Object rowdataObject = this.result.getRows().get(i).getF().get(column - 1).getV();
                if (Data.isNull(rowdataObject)) {
                    return 0;
                }
                String rowdata = (String)rowdataObject;
                if (!rowdata.contains(".") || (pointback = rowdata.length() - rowdata.indexOf(".")) <= max) continue;
                pointback = max;
            }
            return max;
        }
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.logger.debug("Function call getSchemaName(" + column + ") will return empty string ");
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.logger.debug("Function call getTableName(" + column + ") will return empty string ");
        return "";
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new BQSQLException("Not found");
    }
}

