/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.ArrayList;
import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.ColumnCallException;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.BooleanExpressionItem;
import net.starschema.clouddb.jdbc.list.ColumnReference;
import net.starschema.clouddb.jdbc.list.Disjunction;
import net.starschema.clouddb.jdbc.list.JoinExpression;
import net.starschema.clouddb.jdbc.list.Negation;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import net.starschema.clouddb.jdbc.list.UniQueIdContainer;
import org.antlr.runtime.tree.Tree;

public class Conjunction
extends Node {
    public static Node buildFromConjunction(Tree t, TreeBuilder builder, Node mainnode, SelectStatement selectstatement) throws TreeParsingException {
        ArrayList<Disjunction> disjunctionContainer = new ArrayList<Disjunction>();
        ArrayList<Conjunction> conjunctionContainer = new ArrayList<Conjunction>();
        ArrayList<Negation> negationContainer = new ArrayList<Negation>();
        ArrayList<BooleanExpressionItem> booleanExpressionItemContainer = new ArrayList<BooleanExpressionItem>();
        block6: for (int i = 0; i < t.getChildCount(); ++i) {
            Tree child = t.getChild(i);
            switch (child.getType()) {
                case 35: {
                    Disjunction disjunction = new Disjunction(child, builder, mainnode, selectstatement);
                    disjunctionContainer.add(disjunction);
                    continue block6;
                }
                case 27: {
                    Node built = Conjunction.buildFromConjunction(child, builder, mainnode, selectstatement);
                    if (built.getTokenType() == 27) {
                        conjunctionContainer.add((Conjunction)Conjunction.class.cast(built));
                        continue block6;
                    }
                    disjunctionContainer.add((Disjunction)Disjunction.class.cast(built));
                    continue block6;
                }
                case 95: {
                    negationContainer.add(new Negation(child, builder, mainnode, selectstatement));
                    continue block6;
                }
                case 13: {
                    booleanExpressionItemContainer.add(new BooleanExpressionItem(child, builder, mainnode, selectstatement));
                    continue block6;
                }
            }
        }
        if (disjunctionContainer.size() == 0) {
            return new Conjunction(conjunctionContainer, negationContainer, booleanExpressionItemContainer);
        }
        return new Disjunction(disjunctionContainer, conjunctionContainer, negationContainer, booleanExpressionItemContainer);
    }

    public Conjunction(List<Conjunction> conjunctionContainer, List<Negation> negationContainer, List<BooleanExpressionItem> booleanExpressionItemContainer) {
        this.logger.debug("BUILDING CONJUNCTIONNORMALLY");
        if (conjunctionContainer.size() != 0) {
            for (Conjunction conjunction : conjunctionContainer) {
                for (Node item : conjunction.children) {
                    this.children.addLast(item);
                }
                this.logger.debug("ADDING CONJUNCTION TO CONJUNCTION");
            }
        }
        if (negationContainer.size() != 0) {
            for (Negation negation : negationContainer) {
                this.children.addLast(negation);
                this.logger.debug("ADDING NEGATION TO CONJUNCTION");
            }
        }
        if (booleanExpressionItemContainer.size() != 0) {
            for (BooleanExpressionItem booleanExpressionItem : booleanExpressionItemContainer) {
                this.children.addLast(booleanExpressionItem);
                this.logger.debug("ADDING BOOLEANEXPRITEM TO CONJUNCTION");
            }
        }
        this.tokenType = 27;
        this.tokenName = JdbcGrammarParser.tokenNames[27];
    }

    public Conjunction(List<Node> nodelist) {
        this.tokenType = 27;
        this.tokenName = JdbcGrammarParser.tokenNames[27];
        for (Node node : nodelist) {
            this.children.addLast(node);
            this.logger.debug("APPENDNIG CHILDNODE TO CONJUNCTION");
        }
    }

    public Conjunction(List<Node> nodelist, SelectStatement selectStatement) {
        this.tokenType = 27;
        this.tokenName = JdbcGrammarParser.tokenNames[27];
        for (Node node : nodelist) {
            this.children.addLast(node);
            this.logger.debug("APPENDNIG CHILDNODE TO CONJUNCTION");
        }
        block8: for (Node node : this.children) {
            int tokenType2 = node.getTokenType();
            switch (tokenType2) {
                case 13: {
                    UniQueIdContainer PointedNodeInSubQuery;
                    BooleanExpressionItem cast = (BooleanExpressionItem)BooleanExpressionItem.class.cast(node);
                    List<SubQuery> subQueries = selectStatement.getFromExpression().getSubQueries();
                    List<JoinExpression> joinExpressions = selectStatement.getFromExpression().getJoinExpressions();
                    if (joinExpressions != null) {
                        for (JoinExpression joinExpression : joinExpressions) {
                            if (subQueries == null) {
                                subQueries = new ArrayList<SubQuery>();
                            }
                            subQueries.add((SubQuery)SubQuery.class.cast(joinExpression.getLeftItem()));
                            subQueries.add((SubQuery)SubQuery.class.cast(joinExpression.getRightItem()));
                        }
                    }
                    if (cast.left.tokenType == 19) {
                        ColumnReference leftColRef = (ColumnReference)ColumnReference.class.cast(cast.left);
                        if (subQueries != null) {
                            for (SubQuery subQuery : subQueries) {
                                try {
                                    PointedNodeInSubQuery = leftColRef.searchPointedNodeInSubQuery(subQuery);
                                    if (PointedNodeInSubQuery == null) continue;
                                    leftColRef.setPointedNode(PointedNodeInSubQuery);
                                }
                                catch (ColumnCallException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (cast.right.tokenType != 19) break;
                    ColumnReference rightColRef = (ColumnReference)ColumnReference.class.cast(cast.right);
                    if (subQueries == null) continue block8;
                    for (SubQuery subQuery : subQueries) {
                        try {
                            PointedNodeInSubQuery = rightColRef.searchPointedNodeInSubQuery(subQuery);
                            if (PointedNodeInSubQuery == null) continue;
                            rightColRef.setPointedNode(PointedNodeInSubQuery);
                        }
                        catch (ColumnCallException e) {
                            e.printStackTrace();
                        }
                    }
                    continue block8;
                }
            }
        }
    }

    @Override
    public String toPrettyString() {
        String result = "(";
        for (Node item : this.children) {
            result = result + item.toPrettyString() + " AND ";
        }
        result = result.substring(0, result.length() - 5) + ")";
        return result;
    }
}

