% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCTSUpload.R
\name{UCTSAppend}
\alias{UCTSAppend}
\title{Append a xts to an existing UCTS timeseries in Datastream}
\usage{
UCTSAppend(
  tsData,
  TSCode = "",
  MGMTGroup = "ABC",
  freq = c("D", "W", "M", "Q", "Y"),
  seriesName,
  Units = "",
  Decimals = 2,
  ActPer = c("N", "Y"),
  freqConversion = c("ACT", "SUM", "AVG", "END"),
  Alignment = c("1ST", "MID", "END"),
  Carry = c("YES", "NO", "PAD"),
  PrimeCurr = "",
  overwrite = TRUE,
  mydsws = dsws$new(),
  strUsername = ifelse(Sys.getenv("DatastreamUsername") != "",
    Sys.getenv("DatastreamUsername"), options()$Datastream.Username),
  strPassword = ifelse(Sys.getenv("DatastreamPassword") != "",
    Sys.getenv("DatastreamPassword"), options()$Datastream.Password),
  strServerName = "https://product.datastream.com",
  strServerPage = "/UCTS/UCTSMaint.asp"
)
}
\arguments{
\item{tsData}{- an xts (or timeseries object that can be converted to
one) to be uploaded.}

\item{TSCode}{The mnemonic of the target UCTS}

\item{MGMTGroup}{Must have managment group.  Only the first
characters will be used.}

\item{freq}{The frequency of the data to be uploaded}

\item{seriesName}{the name of the series}

\item{Units}{Units of the data - can be no more than 12 characters -
excess will be trimmed to that length}

\item{Decimals}{Number of Decimals in the data - a number between 0 and
9 - if outside that range then trimmed}

\item{ActPer}{Whether the values are percentages ("N") or actual
numbers ("Y")}

\item{freqConversion}{How to do any FX conversions}

\item{Alignment}{Alignment of the data within periods}

\item{Carry}{whether to carry data over missing dates}

\item{PrimeCurr}{the currency of the timeseries}

\item{overwrite}{if TRUE then existing data in the UCTS will be overwritten}

\item{mydsws}{a dsws object that can be passed in.  Use this to avoid creating another dsws
object in the same session.}

\item{strUsername}{your Datastream username}

\item{strPassword}{your Datastream Password}

\item{strServerName}{URL of the Datastream server}

\item{strServerPage}{page on the datastream server}
}
\value{
TRUE if the upload has been a success, otherwise an error message
}
\description{
Uploads and appends an xts into a UCTS in the Datastream Database
}
\details{
This function checks if there is a pre-existing timeseries already in Datastream.
If there is then it will append the xts onto the existing series.  If there are any
overlapping dates then depending on the setting of overwrite then the new data
will overwrite the existing data in the UCTS
}
