% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateParameters.R
\name{estimateParameters}
\alias{estimateParameters}
\title{Estimate parameter in the Random Walk Autoregressive model}
\usage{
estimateParameters(
  y,
  K = 15,
  phiLower = 0,
  phiUpper = 0.999,
  sdEtaUpper = Inf,
  sdNuUpper = Inf,
  model = c("RWAR", "AR", "RW")
)
}
\arguments{
\item{y}{A vector of observations}

\item{K}{The number of K-lags differences of the data to run the robust estimation over. Default set at 15.}

\item{phiLower}{Smallest value of the autocorrelation parameter. Default set at 0.}

\item{phiUpper}{Highest value of the autocorrelation parameter. Default set at 0.99.}

\item{sdEtaUpper}{Highest value of the RW standard deviation. Default set at Inf}

\item{sdNuUpper}{Highest value of the AR(1) noise standard deviation. Default set at Inf}

\item{model}{Constrain estimation to an edge case of the RWAR model. Defaults to \code{"RWAR"}. To fit an AR model only with a piece-wise constant signal, specify \code{"AR"}. To fit a a random walk plus noise, specify \code{"RW"}.}
}
\value{
A list containing:
\describe{
\item{\code{sdEta}}{the SD of the drift (random fluctuations) in the signal,}
\item{\code{sdNu}}{the SD of the AR(1) noise process,}
\item{\code{phi}}{the autocorrelation parameter of the noise process.}
}
}
\description{
This function perform robust estimation of parameters in the Random Walk plus Autoregressive model using
a method of moments estimator. 
Returns a list of estimates that can be employed as an argument for parameter \code{modelParam} to run \code{\link[=DeCAFS]{DeCAFS()}}.
}
\examples{
set.seed(42)
y <- dataRWAR(n = 1e3, phi = .5, sdEta = 1, sdNu = 3,  jumpSize = 15, type = "updown", nbSeg = 5)$y
estimateParameters(y)
}
