% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_functions.R
\name{get_functions}
\alias{get_functions}
\alias{get_estimates}
\alias{draw_assignment}
\alias{draw_sample}
\title{Get estimates, estimands, assignment vectors, or samples from a design given data}
\usage{
get_estimates(design, data = NULL, start = 1, end = length(design))

draw_assignment(design, data = NULL, start = 1, end = length(design))

draw_sample(design, data = NULL, start = 1, end = length(design))
}
\arguments{
\item{design}{A design object, typically created using the + operator}

\item{data}{A data.frame object with sufficient information to get the data, estimates, estimands, an assignment vector, or a sample.}

\item{start}{(Defaults to 1) a scalar indicating which step in the design to begin with. By default all data steps are drawn, from step 1 to the last step of the design.}

\item{end}{(Defaults to \code{length(design)}) a scalar indicating which step in the design to finish with.}
}
\description{
Get estimates, estimands, assignment vectors, or samples from a design given data
}
\examples{

design <- declare_population(N = 100, u = rnorm(N)) +
  declare_potential_outcomes(Y ~ Z + u) +
  declare_estimand(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_sampling(n = 75) +
  declare_assignment(m = 50) +
  declare_reveal(Y, Z) +
  declare_estimator(Y ~ Z, estimand = "ATE")

dat <- draw_data(design)

draw_data(design, data = dat, start = 2)

get_estimates(design, data = dat)

draw_assignment(design, data = dat)

draw_sample(design, data = dat)

}
