% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis_helper_functions.R
\name{reshape_diagnosis}
\alias{reshape_diagnosis}
\title{Clean up a diagnosis object for printing}
\usage{
reshape_diagnosis(diagnosis, digits = 2, select = NULL, exclude = NULL)
}
\arguments{
\item{diagnosis}{A diagnosis object generated by \code{diagnose_design}.}

\item{digits}{Number of digits.}

\item{select}{List of columns to include in output. Defaults to all.}

\item{exclude}{Set of columns to exclude from output. Defaults to none.}
}
\value{
A formatted text table with bootstrapped standard errors in parentheses.
}
\description{
Take a diagnosis object and returns a pretty output table. If diagnosands are bootstrapped, se's are put in parentheses on a second line and rounded to \code{digits}.
}
\examples{

effect_size <- 0.1
design <-
  declare_model(
    N = 100,
    U = rnorm(N),
    X = rnorm(N),
    potential_outcomes(Y ~ effect_size * Z + X + U)
  ) +
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_assignment(Z = complete_ra(N)) +
  declare_measurement(Y = reveal_outcomes(Y ~ Z)) +
  declare_estimator(Y ~ Z, inquiry = "ATE", label = "unadjusted") + 
  declare_estimator(Y ~ Z + X, inquiry = "ATE", label = "adjusted")

diagnosis <- diagnose_design(design, sims = 100)

reshape_diagnosis(diagnosis)

reshape_diagnosis(diagnosis, select = c("Bias", "Power"))
}
