/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rosuda.JGR.DataLoader;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.SaveData;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.ExScrollableTable;
import org.rosuda.deducer.data.ExTable;
import org.rosuda.deducer.data.RDataFrameModel;
import org.rosuda.deducer.data.RDataFrameVariableModel;
import org.rosuda.deducer.menu.FactorDialog;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class DataFrameWindow
extends TJFrame
implements ActionListener {
    private ExScrollableTable dataScrollPane;
    private ExScrollableTable variableScrollPane;
    private IconButton jButton2;
    private JTabbedPane jTabbedPane1;
    private IconButton jButton1;
    private IconButton button1;
    private JSeparator separator2;
    private JSeparator separator1;
    private JLabel dataSelectorLabel;
    private JComboBox dataSelector;
    private JPanel dataSelectorPanel;
    private ExTable table;
    private DataFrameWindow theWindow = this;
    private String showData = null;
    public static ArrayList dataWindows;

    public DataFrameWindow() {
        super("Data Viewer", false, 154);
        this.initGUI(null);
        new Thread(new Refresher()).start();
        if (dataWindows == null) {
            dataWindows = new ArrayList();
        }
        dataWindows.add(0, this);
    }

    public DataFrameWindow(ExTable exTable) {
        super("Data Viewer", false, 154);
        this.initGUI(exTable);
        new Thread(new Refresher()).start();
        if (dataWindows == null) {
            dataWindows = new ArrayList();
        }
        dataWindows.add(0, this);
    }

    private void initGUI(ExTable exTable) {
        try {
            this.setName("Data Viewer");
            RController.refreshObjects();
            BorderLayout borderLayout = new BorderLayout();
            this.getContentPane().setLayout(borderLayout);
            this.setDefaultCloseOperation(2);
            this.setMinimumSize(new Dimension(400, 400));
            this.dataSelectorPanel = new JPanel();
            this.getContentPane().add((Component)this.dataSelectorPanel, "North");
            String[] stringArray = new AnchorLayout();
            this.dataSelectorPanel.setLayout((LayoutManager)stringArray);
            this.dataSelectorPanel.setPreferredSize(new Dimension(839, 52));
            this.dataSelectorPanel.setSize(10, 10);
            this.dataSelectorPanel.setMinimumSize(new Dimension(100, 100));
            this.button1 = new IconButton("/icons/kfloppy.png", "Save Data", this, "Save Data");
            this.dataSelectorPanel.add((Component)this.button1, new AnchorConstraint(12, 60, 805, 62, 2, 0, 0, 2));
            this.button1.setFont(new Font("Dialog", 0, 8));
            this.button1.setPreferredSize(new Dimension(32, 32));
            this.separator2 = new JSeparator();
            this.dataSelectorPanel.add((Component)this.separator2, new AnchorConstraint(-76, 620, 1008, 608, 1, 1, 1, 1));
            this.separator2.setPreferredSize(new Dimension(10, 64));
            this.separator2.setOrientation(1);
            this.separator1 = new JSeparator();
            this.dataSelectorPanel.add((Component)this.separator1, new AnchorConstraint(8, 415, 1076, 402, 1, 1, 1, 1));
            this.separator1.setPreferredSize(new Dimension(11, 63));
            this.separator1.setOrientation(1);
            this.dataSelectorLabel = new JLabel();
            this.dataSelectorPanel.add((Component)this.dataSelectorLabel, new AnchorConstraint(48, 595, 432, 415, 1, 1, 1, 1));
            this.dataSelectorLabel.setText("Data Set");
            this.dataSelectorLabel.setPreferredSize(new Dimension(151, 20));
            this.dataSelectorLabel.setFont(new Font("Dialog", 0, 14));
            this.dataSelectorLabel.setHorizontalAlignment(0);
            this.dataSelectorLabel.setHorizontalTextPosition(0);
            Serializable serializable = new DataFrameComboBoxModel(JGR.DATA);
            this.dataSelector = new JComboBox();
            this.dataSelectorPanel.add((Component)this.dataSelector, new AnchorConstraint(432, 594, 906, 415, 1, 1, 1, 1));
            this.dataSelector.setModel(serializable);
            this.dataSelector.setPreferredSize(new Dimension(149, 28));
            this.dataSelector.addActionListener(this);
            this.jButton1 = new IconButton("/icons/opendata_24.png", "Open Data", this, "Open Data");
            this.dataSelectorPanel.add((Component)this.jButton1, new AnchorConstraint(12, 60, 805, 12, 2, 0, 0, 2));
            this.jButton1.setPreferredSize(new Dimension(32, 32));
            this.jButton2 = new IconButton("/icons/trashcan_remove_32.png", "Clear", this, "Clear Data");
            this.dataSelectorPanel.add((Component)this.jButton2, new AnchorConstraint(144, 12, 971, 863, 0, 2, 1, 0));
            this.jButton2.setPreferredSize(new Dimension(40, 40));
            this.jTabbedPane1 = new JTabbedPane();
            this.getContentPane().add((Component)this.jTabbedPane1, "Center");
            this.jTabbedPane1.setPreferredSize(new Dimension(839, 395));
            this.jTabbedPane1.setTabPlacement(2);
            if (exTable == null) {
                if (JGR.DATA == null || JGR.DATA.size() == 0) {
                    this.dataScrollPane = null;
                    this.variableScrollPane = null;
                    this.jTabbedPane1.addTab("Data View", null, this.defaultPanel(), null);
                    this.jTabbedPane1.addTab("Variable View", null, this.defaultPanel(), null);
                } else {
                    this.jTabbedPane1.addTab("Data View", null, this.defaultPanel(), null);
                    this.jTabbedPane1.addTab("Variable View", null, this.defaultPanel(), null);
                    this.setDataView(((RObject)JGR.DATA.elementAt(0)).getName());
                    this.setVariableView(((RObject)JGR.DATA.elementAt(0)).getName());
                }
            } else {
                this.table = exTable;
                this.dataScrollPane = new ExScrollableTable(this.table);
            }
            stringArray = new String[]{"+", "File", "@NNew Data", "newdata", "@LOpen Data", "loaddata", "@SSave Data", "Save Data", "-", "-", "@PPrint", "print", "~File.Quit", "+", "Edit", "@CCopy", "copy", "@XCut", "cut", "@VPaste", "paste", "-", "Remove Data", "Clear Data", "~Window", "+", "Help", "R Help", "help", "~About", "0"};
            serializable = EzMenuSwing.getEzMenu(this, this, stringArray);
            if (!Common.isMac()) {
                EzMenuSwing.addMenuSeparator(this, "Edit");
                EzMenuSwing.addJMenuItem(this, "Help", "About", "about", this);
                this.jTabbedPane1.setTabPlacement(1);
                for (int i = 0; i < ((JMenuBar)serializable).getMenuCount(); ++i) {
                    if (!((JMenuBar)serializable).getMenu(i).getText().equals("About")) continue;
                    ((Container)serializable).remove(i);
                    --i;
                }
            }
            this.pack();
            this.setSize(839, 839);
            final DataFrameWindow dataFrameWindow = this;
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    dataFrameWindow.setSize(Math.max(300, dataFrameWindow.getWidth()), dataFrameWindow.getHeight());
                }
            });
            this.addWindowFocusListener(new WindowAdapter(){

                public void windowGainedFocus(WindowEvent windowEvent) {
                    try {
                        int n;
                        dataWindows.remove(DataFrameWindow.this.theWindow);
                        dataWindows.add(0, DataFrameWindow.this.theWindow);
                        REXP rEXP = Deducer.idleEval("2");
                        for (n = 1; rEXP == null && n <= 3; ++n) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            rEXP = Deducer.idleEval("2");
                        }
                        if (n == 4) {
                            JGR.MAINRCONSOLE.toFront();
                            JGR.MAINRCONSOLE.requestFocus();
                            return;
                        }
                        RController.refreshObjects();
                        ((DataFrameComboBoxModel)DataFrameWindow.this.dataSelector.getModel()).refresh(JGR.DATA);
                        if (JGR.DATA.size() == 0) {
                            DataFrameWindow.this.dataScrollPane = null;
                            DataFrameWindow.this.jTabbedPane1.setComponentAt(0, DataFrameWindow.this.defaultPanel());
                            DataFrameWindow.this.jTabbedPane1.setComponentAt(1, DataFrameWindow.this.defaultPanel());
                        } else if (DataFrameWindow.this.dataScrollPane == null) {
                            RObject rObject = (RObject)JGR.DATA.elementAt(0);
                            DataFrameWindow.this.dataSelector.setSelectedItem(rObject);
                            DataFrameWindow.this.setDataView(rObject.getName());
                            DataFrameWindow.this.setVariableView(rObject.getName());
                        } else {
                            DataFrameWindow.this.refresh();
                        }
                    }
                    catch (Exception exception) {
                        new ErrorMsg(exception);
                    }
                }
            });
            this.jTabbedPane1.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = DataFrameWindow.this.jTabbedPane1.getSelectedIndex();
                    if (n == 1) {
                        ((RDataFrameVariableModel)DataFrameWindow.this.variableScrollPane.getExTable().getModel()).refresh();
                        DataFrameWindow.this.variableScrollPane.getRowNamesModel().refresh();
                    } else if (n == 0) {
                        DataFrameWindow.this.dataScrollPane.getRowNamesModel().refresh();
                        ((RDataFrameModel)DataFrameWindow.this.dataScrollPane.getExTable().getModel()).refresh();
                    }
                }
            });
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void refresh() {
        boolean bl = false;
        if (this.dataScrollPane != null && (bl = ((RDataFrameModel)this.dataScrollPane.getExTable().getModel()).refresh())) {
            this.dataScrollPane.getRowNamesModel().refresh();
            this.dataScrollPane.autoAdjustRowWidth();
        }
        if (this.variableScrollPane != null && bl) {
            ((RDataFrameVariableModel)this.variableScrollPane.getExTable().getModel()).refresh();
            this.variableScrollPane.getRowNamesModel().refresh();
            this.variableScrollPane.autoAdjustRowWidth();
        }
    }

    public synchronized void showData(String string) {
        this.showData = string;
    }

    public static void setTopDataWindow(String string) {
        if (dataWindows == null) {
            dataWindows = new ArrayList();
        }
        if (dataWindows.size() > 0) {
            for (int i = 0; i < dataWindows.size(); ++i) {
                if (((DataFrameWindow)dataWindows.get(i)).isVisible()) {
                    ((DataFrameWindow)dataWindows.get(i)).showData(string);
                    ((DataFrameWindow)dataWindows.get(i)).toFront();
                    return;
                }
                dataWindows.remove(i);
            }
        }
    }

    public void setVisibleDataFrame(String string) {
        for (int i = 0; i < this.dataSelector.getModel().getSize(); ++i) {
            String string2 = ((DataFrameComboBoxModel)this.dataSelector.getModel()).getNameAt(i);
            if (!string2.equals(string)) continue;
            this.dataSelector.setSelectedIndex(i);
            this.dataSelector.repaint();
        }
    }

    public void setDataView(String string) {
        if (this.dataScrollPane == null) {
            RDataFrameModel rDataFrameModel = new RDataFrameModel(string);
            this.table = new ExTable(rDataFrameModel);
            this.dataScrollPane = new ExScrollableTable(this.table);
            this.dataScrollPane.setRowNamesModel(((RDataFrameModel)this.dataScrollPane.getExTable().getModel()).getRowNamesModel());
            this.dataScrollPane.getExTable().setDefaultRenderer(Object.class, new RDataFrameModel.RCellRenderer(rDataFrameModel));
            if (this.jTabbedPane1.getTabCount() > 0) {
                this.jTabbedPane1.setComponentAt(0, this.dataScrollPane);
            }
        } else {
            ((RDataFrameModel)this.dataScrollPane.getExTable().getModel()).setDataName(string);
            this.dataScrollPane.getRowNamesModel().refresh();
            this.dataScrollPane.autoAdjustRowWidth();
        }
    }

    public void setVariableView(String string) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("String");
        jComboBox.addItem("Factor");
        jComboBox.addItem("Double");
        jComboBox.addItem("Integer");
        jComboBox.addItem("Logical");
        RDataFrameVariableModel rDataFrameVariableModel = new RDataFrameVariableModel(string);
        ExTable exTable = new ExTable();
        exTable.setModel(rDataFrameVariableModel);
        exTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
        exTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        exTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        exTable.getColumnModel().getColumn(2).setPreferredWidth(300);
        exTable.setColumnSelectionAllowed(true);
        exTable.setRowSelectionAllowed(true);
        exTable.getTableHeader().removeMouseListener(exTable.getColumnListener());
        exTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ExTable exTable = (ExTable)mouseEvent.getSource();
                if (exTable.getSelectedColumn() == 2) {
                    int n = exTable.getSelectedRow();
                    String string = (String)exTable.getModel().getValueAt(n, 0);
                    String string2 = ((RObject)DataFrameWindow.this.dataSelector.getSelectedItem()).getName();
                    REXPLogical rEXPLogical = (REXPLogical)Deducer.eval("is.factor(" + string2 + "$" + string + ")");
                    if (rEXPLogical != null && rEXPLogical.isTRUE()[0]) {
                        FactorDialog factorDialog = new FactorDialog(null, string2 + "$" + string);
                        factorDialog.setLocation(mouseEvent.getPoint());
                        factorDialog.setTitle("Factor Editor: " + string);
                        factorDialog.setVisible(true);
                    }
                }
            }
        });
        this.variableScrollPane = new ExScrollableTable(exTable);
        this.variableScrollPane.setRowNamesModel(new RDataFrameVariableModel.VariableNumberListModel(rDataFrameVariableModel));
        this.variableScrollPane.displayContextualMenu(false);
        if (this.jTabbedPane1.getTabCount() > 0) {
            this.jTabbedPane1.setComponentAt(1, this.variableScrollPane);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string == "comboBoxChanged") {
                if (this.dataScrollPane == null) {
                    this.setDataView(((RObject)this.dataSelector.getSelectedItem()).getName());
                    this.setVariableView(((RObject)this.dataSelector.getSelectedItem()).getName());
                    this.refresh();
                } else if (!((RObject)this.dataSelector.getSelectedItem()).getName().equals(((RDataFrameModel)this.dataScrollPane.getExTable().getModel()).getDataName())) {
                    this.setDataView(((RObject)this.dataSelector.getSelectedItem()).getName());
                    this.setVariableView(((RObject)this.dataSelector.getSelectedItem()).getName());
                    this.refresh();
                }
            } else if (string == "Open Data") {
                JGR.MAINRCONSOLE.toFront();
                JGR.MAINRCONSOLE.requestFocus();
                new DataLoader();
            } else if (string == "Save Data") {
                new SaveData(((RObject)this.dataSelector.getSelectedItem()).getName());
            } else if (string == "Clear Data") {
                if (this.dataSelector.getSelectedItem() == null) {
                    JOptionPane.showMessageDialog(this, "Invalid selection: There is no data loaded.");
                    return;
                }
                String string2 = ((RObject)this.dataSelector.getSelectedItem()).getName();
                int n = JOptionPane.showConfirmDialog(null, "Remove Data Frame " + string2 + " from enviornment?\n" + "Unsaved changes will be lost.", "Clear Data Frame", 0, 3);
                if (n == 1) {
                    return;
                }
                JGR.MAINRCONSOLE.executeLater("rm(" + string2 + ")");
                RController.refreshObjects();
            } else if (string == "about") {
                new AboutDialog((JFrame)this);
            } else if (string == "cut") {
                if (this.jTabbedPane1.getSelectedComponent() instanceof ExScrollableTable) {
                    ((ExScrollableTable)this.jTabbedPane1.getSelectedComponent()).getExTable().cutSelection();
                }
            } else if (string == "copy") {
                if (this.jTabbedPane1.getSelectedComponent() instanceof ExScrollableTable) {
                    ((ExScrollableTable)this.jTabbedPane1.getSelectedComponent()).getExTable().copySelection();
                }
            } else if (string == "print") {
                try {
                    ((ExScrollableTable)this.jTabbedPane1.getSelectedComponent()).getExTable().print(JTable.PrintMode.NORMAL);
                }
                catch (Exception exception) {}
            } else if (string == "editor") {
                new Editor();
            } else if (string == "exit") {
                this.dispose();
            } else if (string == "newdata") {
                String string3 = JOptionPane.showInputDialog("Data Name: ");
                if ((string3 = JGR.MAINRCONSOLE.getUniqueName(string3)) != null) {
                    Deducer.eval(string3.trim() + "<-data.frame(Var1=NA)");
                    RController.refreshObjects();
                    ((DataFrameComboBoxModel)this.dataSelector.getModel()).refresh(JGR.DATA);
                    Deducer.eval(string3.trim());
                    for (int i = 0; i < this.dataSelector.getItemCount(); ++i) {
                        if (!((RObject)this.dataSelector.getItemAt(i)).getName().equals(string3.trim())) continue;
                        this.dataSelector.setSelectedIndex(i);
                    }
                }
            } else if (string == "loaddata") {
                DataLoader dataLoader = new DataLoader();
                DataFrameWindow.setTopDataWindow(dataLoader.getDataName());
                ((JFrame)dataWindows.get(0)).toFront();
            } else if (string == "help") {
                Deducer.execute("help.start()");
            } else if (string == "table") {
                DataFrameWindow dataFrameWindow = new DataFrameWindow();
                dataFrameWindow.setLocationRelativeTo(null);
                dataFrameWindow.setVisible(true);
            } else if (string == "save") {
                new SaveData(((RObject)this.dataSelector.getSelectedItem()).getName());
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    private JPanel defaultPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
        jPanel.setLayout(gridBagLayout);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = actionEvent.getActionCommand();
                if (string2 == "Open Data") {
                    new DataLoader();
                    JGR.MAINRCONSOLE.toFront();
                } else if (string2 == "New Data" && (string = JOptionPane.showInputDialog("Data Name: ")) != null) {
                    Deducer.eval(string.trim() + "<-data.frame()");
                }
            }
        };
        IconButton iconButton = new IconButton("/icons/newdata_128.png", "New Data Frame", actionListener, "New Data");
        iconButton.setPreferredSize(new Dimension(128, 128));
        jPanel.add((Component)iconButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        IconButton iconButton2 = new IconButton("/icons/opendata_128.png", "Open Data Frame", actionListener, "Open Data");
        iconButton2.setPreferredSize(new Dimension(128, 128));
        jPanel.add((Component)iconButton2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void dispose() {
        dataWindows.remove(this);
        super.dispose();
        if (this.dataScrollPane != null) {
            ((RDataFrameModel)this.dataScrollPane.getExTable().getModel()).removeCachedData();
        }
    }

    public void setDataDependentMenusEnabled(boolean bl) {
        String[] stringArray = new String[]{"Edit Factor", "Recode", "rowReset", "Sort", "Merge", "transpose", "Frequencies", "Descriptives", "Subset", "contin", "One Sample", "Two Sample", "ksample", "corr"};
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem = EzMenuSwing.getItem(this, stringArray[i]);
            if (jMenuItem == null) continue;
            jMenuItem.setEnabled(bl);
        }
    }

    class Refresher
    implements Runnable {
        public void run() {
            DataFrameWindow dataFrameWindow = DataFrameWindow.this.theWindow;
            boolean bl = true;
            while (bl) {
                try {
                    Thread.sleep(2000L);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            DataFrameWindow.this.refresh();
                            if (Deducer.getData().size() == 0) {
                                DataFrameWindow.this.setDataDependentMenusEnabled(false);
                            } else {
                                DataFrameWindow.this.setDataDependentMenusEnabled(true);
                            }
                            ((DataFrameComboBoxModel)DataFrameWindow.this.dataSelector.getModel()).refresh(Deducer.getData());
                            if (DataFrameWindow.this.dataSelector.getModel().getSize() == 0 && DataFrameWindow.this.dataScrollPane != null) {
                                DataFrameWindow.this.jTabbedPane1.setComponentAt(0, DataFrameWindow.this.defaultPanel());
                                DataFrameWindow.this.jTabbedPane1.setComponentAt(1, DataFrameWindow.this.defaultPanel());
                                DataFrameWindow.this.dataScrollPane = null;
                                DataFrameWindow.this.variableScrollPane = null;
                            }
                        }
                    };
                    if (dataFrameWindow == null || !dataFrameWindow.isDisplayable()) {
                        bl = false;
                        if (DataFrameWindow.this.dataScrollPane == null) continue;
                        ((RDataFrameModel)DataFrameWindow.this.dataScrollPane.getExTable().getModel()).removeCachedData();
                        continue;
                    }
                    SwingUtilities.invokeLater(runnable);
                    if (DataFrameWindow.this.showData == null) continue;
                    DataFrameWindow.this.setVisibleDataFrame(DataFrameWindow.this.showData);
                    if (!((RObject)DataFrameWindow.this.dataSelector.getSelectedItem()).getName().equals(DataFrameWindow.this.showData)) continue;
                    DataFrameWindow.this.showData = null;
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                }
            }
        }
    }

    public class DataFrameComboBoxModel
    extends DefaultComboBoxModel {
        private Vector items;
        private int selectedIndex = 0;

        public Object getElementAt(int n) {
            return this.items.elementAt(n);
        }

        public int getIndexOf(Object object) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.elementAt(i) != object) continue;
                return i;
            }
            return -1;
        }

        public int getSize() {
            return this.items.size();
        }

        public Object getSelectedItem() {
            if (this.items.size() > 0) {
                return this.items.elementAt(this.selectedIndex);
            }
            return null;
        }

        public String getNameAt(int n) {
            return ((RObject)this.items.elementAt(n)).getName();
        }

        public void setSelectedItem(Object object) {
            this.selectedIndex = this.getIndexOf(object);
        }

        public DataFrameComboBoxModel(Vector vector) {
            this.items = new Vector(vector);
        }

        public void refresh(Vector vector) {
            String string = null;
            this.removeAllElements();
            int n = this.items.size();
            if (this.getSelectedItem() != null) {
                string = ((RObject)this.getSelectedItem()).getName();
            }
            this.items = new Vector(vector);
            this.selectedIndex = 0;
            if (this.items.size() > 0) {
                for (int i = 0; i < this.items.size(); ++i) {
                    if (!((RObject)this.items.elementAt(i)).getName().equals(string)) continue;
                    this.selectedIndex = i;
                }
                this.fireContentsChanged(this, 0, n);
            }
        }
    }
}

