/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.ExCellRenderer;
import org.rosuda.deducer.data.ExDefaultTableModel;
import org.rosuda.deducer.data.RowNamesListModel;

class RDataFrameModel
extends ExDefaultTableModel {
    private static String guiEnv = Deducer.guiEnv;
    private String rDataName = null;
    private String tempDataName = null;
    RowNamesModel rowNamesModel = new RowNamesModel();
    public static final int numExtensionRows = 50;
    public static final int numExtensionColumns = 10;

    public RDataFrameModel() {
    }

    public RDataFrameModel(String string) {
        this.setDataName(string);
    }

    public String getDataName() {
        return this.rDataName;
    }

    public void setDataName(String string) {
        boolean bl = ((REXPLogical)Deducer.eval("'" + guiEnv + "' %in% .getOtherObjects()")).isTRUE()[0];
        if (!bl) {
            Deducer.eval(guiEnv + "<-new.env(parent=emptyenv())");
        }
        if (this.tempDataName != null) {
            Deducer.eval("rm(" + this.tempDataName + ",envir=" + guiEnv + ")");
        }
        this.rDataName = string;
        this.tempDataName = Deducer.getUniqueName(this.rDataName, guiEnv);
        Deducer.eval(guiEnv + "$" + this.tempDataName + "<-" + this.rDataName);
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        if (this.rDataName != null) {
            boolean bl = ((REXPLogical)Deducer.eval("!exists('" + this.rDataName + "')")).isTRUE()[0];
            if (bl) {
                return 0;
            }
            try {
                return Deducer.eval("ncol(" + this.rDataName + ")").asInteger() + 10;
            }
            catch (REXPMismatchException rEXPMismatchException) {
                return 0;
            }
        }
        return 0;
    }

    public int getRealColumnCount() {
        if (this.rDataName != null) {
            if (((REXPLogical)Deducer.eval("!exists('" + this.rDataName + "')")).isTRUE()[0]) {
                return 0;
            }
            try {
                return Deducer.eval("ncol(" + this.rDataName + ")").asInteger();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                return 0;
            }
        }
        return 0;
    }

    public int getRealRowCount() {
        if (this.rDataName != null) {
            if (((REXPLogical)Deducer.eval("!exists('" + this.rDataName + "')")).isTRUE()[0]) {
                return 0;
            }
            try {
                return Deducer.eval("nrow(" + this.rDataName + ")").asInteger();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                return 0;
            }
        }
        return 0;
    }

    public int getRowCount() {
        if (this.rDataName != null) {
            if (((REXPLogical)Deducer.eval("!exists('" + this.rDataName + "')")).isTRUE()[0]) {
                return 0;
            }
            try {
                return Deducer.eval("nrow(" + this.rDataName + ")").asInteger() + 50;
            }
            catch (REXPMismatchException rEXPMismatchException) {
                return 0;
            }
        }
        return 0;
    }

    public void removeColumn(int n) {
        if (n < this.getRealColumnCount()) {
            Deducer.eval(this.rDataName + "<-" + this.rDataName + "[,-" + (n + 1) + "]");
            this.refresh();
        }
    }

    public void removeRow(int n) {
        if (n + 1 <= this.getRealRowCount()) {
            Deducer.eval(this.rDataName + "<- " + this.rDataName + "[-" + (n + 1) + ",]");
            this.refresh();
        }
    }

    public void insertNewColumn(int n) {
        if (n > this.getRealColumnCount() + 1) {
            return;
        }
        if (n < 1) {
            Deducer.eval(this.rDataName + "<-data.frame(V=as.integer(NA)," + this.rDataName + "[," + (n + 1) + ":" + this.getRealColumnCount() + ",drop=FALSE])");
        } else if (n >= this.getRealColumnCount()) {
            Deducer.eval(this.rDataName + "<-data.frame(" + this.rDataName + ",V=as.integer(NA))");
        } else {
            Deducer.eval(this.rDataName + "<-data.frame(" + this.rDataName + "[,1:" + n + ",drop=FALSE],V=as.integer(NA)," + this.rDataName + "[," + (n + 1) + ":" + this.getRealColumnCount() + ",drop=FALSE])");
        }
        this.refresh();
    }

    public void insertNewRow(int n) {
        int n2 = this.getRealRowCount();
        this.setValueAt("NA", Math.max(n2, n), 0);
        Deducer.eval("attr(" + this.rDataName + ",'row.names')[" + (Math.max(n2, n) + 1) + "]<-'New'");
        if (n < 1) {
            Deducer.eval(this.rDataName + "<-rbind(" + this.rDataName + "[" + (n2 + 1) + ",]," + this.rDataName + "[" + (n + 1) + ":" + n2 + ",,drop=FALSE])");
        } else if (n < n2) {
            Deducer.eval(this.rDataName + "<-rbind(" + this.rDataName + "[1:" + n + ",,drop=FALSE]," + this.rDataName + "[" + (n2 + 1) + ",]," + this.rDataName + "[" + (n + 1) + ":" + n2 + ",,drop=FALSE])");
        }
        Deducer.eval("rownames(" + this.rDataName + ")<-make.unique(rownames(" + this.rDataName + "))");
    }

    public Object getValueAt(int n, int n2) {
        Object object = "?";
        try {
            if (n >= this.getRealRowCount() || n2 >= this.getRealColumnCount()) {
                object = "";
            } else {
                REXP rEXP = Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]");
                if (rEXP.isNA()[0]) {
                    object = new NAHolder();
                } else if (rEXP.isFactor()) {
                    object = rEXP.asFactor().asStrings()[0];
                } else if (rEXP.isInteger()) {
                    object = new Integer(rEXP.asInteger());
                } else if (rEXP.isLogical()) {
                    object = new Boolean(((REXPLogical)rEXP).isTRUE()[0]);
                } else if (rEXP.isNumeric()) {
                    object = new Double(rEXP.asDouble());
                } else if (rEXP.isString()) {
                    object = ((REXPLogical)Deducer.eval("is.na(" + this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "])")).isTRUE()[0] ? new NAHolder() : rEXP.asString();
                }
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            object = "?";
        }
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!this.isCellEditable(n, n2)) {
            return;
        }
        REXP rEXP = Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]");
        int n3 = this.getRealRowCount();
        int n4 = this.getRealColumnCount();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        if (object != null) {
            string = object.toString().trim();
            bl = true;
            try {
                Double.parseDouble(string);
            }
            catch (Exception exception) {
                bl = false;
            }
            bl2 = true;
            try {
                Integer.parseInt(string);
            }
            catch (Exception exception) {
                bl2 = false;
            }
        }
        if (object == null) {
            if (n + 1 <= n3 && n2 + 1 <= n4) {
                Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-NA");
            }
        } else if (rEXP.isNull()) {
            if (!bl) {
                if (object.toString().equals("NA")) {
                    Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-NA");
                } else if (object.toString().toLowerCase().equals("true")) {
                    Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-TRUE");
                } else if (object.toString().toLowerCase().equals("false")) {
                    Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-FALSE");
                } else {
                    Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-'" + object.toString() + "'");
                }
            } else {
                Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-" + string);
            }
        } else if (object.toString().equals("NA")) {
            Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-NA");
        } else if (rEXP.isString()) {
            Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-'" + object.toString() + "'");
        } else if (rEXP.isInteger()) {
            if (!bl2) {
                if (!bl) {
                    Deducer.eval(this.rDataName + "[," + (n2 + 1) + "]<-as.character(" + this.rDataName + "[," + (n2 + 1) + "])");
                    Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-'" + object.toString() + "'");
                } else {
                    Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-" + string);
                    this.fireTableDataChanged();
                }
            } else {
                Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-" + string + "L");
            }
        } else if (rEXP.isFactor()) {
            boolean bl3 = ((REXPLogical)Deducer.eval("'" + object.toString() + "' %in% " + "levels(" + this.rDataName + "[," + (n2 + 1) + "])")).isFALSE()[0];
            if (bl3) {
                String string2 = "levels(" + this.rDataName + "[," + (n2 + 1) + "])<-c(" + "levels(" + this.rDataName + "[," + (n2 + 1) + "]),'" + object.toString() + "')";
                Deducer.eval(string2);
            }
            Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-'" + object.toString() + "'");
        } else if (rEXP.isLogical()) {
            if (string.equals("1") || string.toLowerCase().equals("true") || string.toLowerCase().equals("t")) {
                Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-TRUE");
            } else if (string.equals("0") || string.toLowerCase().equals("false") || string.toLowerCase().equals("f")) {
                Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-FALSE");
            } else {
                Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-'" + string + "'");
            }
        } else if (rEXP.isNumeric()) {
            if (!bl) {
                Deducer.eval(this.rDataName + "[," + (n2 + 1) + "]<-as.character(" + this.rDataName + "[," + (n2 + 1) + "])");
                Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-'" + object.toString() + "'");
            } else {
                Deducer.eval(this.rDataName + "[" + (n + 1) + "," + (n2 + 1) + "]<-" + string);
            }
        }
        this.fireTableCellUpdated(n, n2);
        if (n + 1 > n3) {
            Deducer.eval("rownames(" + this.rDataName + ")<-make.unique(rownames(" + this.rDataName + "))");
            this.fireTableRowsInserted(n3, n);
            this.fireTableRowsUpdated(n3, n);
        }
        if (n2 + 1 > n4) {
            this.fireTableDataChanged();
            try {
                this.addColumn(Deducer.eval("colnames(" + this.rDataName + ")[" + (n2 + 1) + "]").asString());
            }
            catch (REXPMismatchException rEXPMismatchException) {
                // empty catch block
            }
        }
        Deducer.eval(guiEnv + "$" + this.tempDataName + "<-" + this.rDataName);
    }

    public boolean refresh() {
        REXP rEXP;
        boolean bl = false;
        REXP rEXP2 = Deducer.idleEval("exists('" + this.rDataName + "')");
        if (rEXP2 != null && ((REXPLogical)rEXP2).isTRUE()[0] && (rEXP = Deducer.idleEval("identical(" + this.rDataName + "," + guiEnv + "$" + this.tempDataName + ")")) != null && ((REXPLogical)rEXP).isFALSE()[0]) {
            REXP rEXP3 = Deducer.eval("all(dim(" + this.rDataName + ")==dim(" + guiEnv + "$" + this.tempDataName + ")) && " + "identical(colnames(" + this.rDataName + "),colnames(" + guiEnv + "$" + this.tempDataName + "))");
            if (rEXP3 != null && ((REXPLogical)rEXP3).isTRUE()[0]) {
                this.fireTableStructureChanged();
            }
            if (rEXP3 != null) {
                this.fireTableDataChanged();
            }
            Deducer.eval(guiEnv + "$" + this.tempDataName + "<-" + this.rDataName);
            bl = true;
        }
        return bl;
    }

    public String getColumnName(int n) {
        if (n < this.getRealColumnCount()) {
            REXP rEXP = Deducer.eval("colnames(" + this.rDataName + ")[" + (n + 1) + "]");
            if (rEXP.isString()) {
                try {
                    return rEXP.asString();
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    return "?";
                }
            }
            return "?";
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 <= this.getRealColumnCount();
    }

    public void removeCachedData() {
        boolean bl = ((REXPLogical)Deducer.eval("exists('" + this.tempDataName + "',where=" + guiEnv + ",inherits=FALSE)")).isTRUE()[0];
        if (bl) {
            Deducer.eval("rm(" + this.tempDataName + ",envir=" + guiEnv + ")");
        }
    }

    protected void finalize() throws Throwable {
        this.removeCachedData();
        super.finalize();
    }

    public RowNamesListModel getRowNamesModel() {
        return this.rowNamesModel;
    }

    public void setRowNamesModel(RowNamesModel rowNamesModel) {
        this.rowNamesModel = rowNamesModel;
    }

    public class RCellRenderer
    extends ExCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n < RDataFrameModel.this.getRealRowCount() || n2 < RDataFrameModel.this.getRealColumnCount()) {
                if (object instanceof NAHolder) {
                    this.setHorizontalAlignment(4);
                    this.setVerticalAlignment(3);
                    Font font = new Font("Dialog", 0, 6);
                    this.setFont(font);
                } else if (object instanceof String) {
                    this.setHorizontalAlignment(2);
                    this.setVerticalAlignment(0);
                } else {
                    this.setHorizontalAlignment(4);
                    this.setVerticalAlignment(0);
                }
            }
            return this;
        }
    }

    public class NAHolder {
        public String toString() {
            return "NA";
        }
    }

    class RowNamesModel
    extends RowNamesListModel {
        RowNamesModel() {
        }

        public int getSize() {
            return RDataFrameModel.this.getRowCount();
        }

        public Object getElementAt(int n) {
            if (n < RDataFrameModel.this.getRealRowCount()) {
                REXP rEXP = Deducer.eval("rownames(" + RDataFrameModel.this.rDataName + ")[" + (n + 1) + "]");
                if (rEXP.isString()) {
                    try {
                        return rEXP.asString();
                    }
                    catch (REXPMismatchException rEXPMismatchException) {
                        return "?";
                    }
                }
                return "?";
            }
            return new Integer(n + 1).toString();
        }

        public void initHeaders(int n) {
        }

        public int getMaxNumChar() {
            String[] stringArray = new String[]{""};
            try {
                stringArray = Deducer.eval("rownames(" + RDataFrameModel.this.rDataName + ")").asStrings();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                // empty catch block
            }
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                n = Math.max(n, stringArray[i].length());
            }
            return n;
        }
    }
}

