/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import edu.cens.spatial.plots.ElementModel;
import edu.cens.spatial.plots.widgets.ParamSpatialVariable;
import edu.cens.spatial.plots.widgets.RPointFunction;
import java.awt.Color;
import javax.swing.JDialog;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamColor;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.RFunction;
import org.rosuda.deducer.widgets.param.RFunctionDialog;

public class BubbleElementModel
extends ElementModel {
    RFunction rf;

    public BubbleElementModel() {
        this.init();
    }

    public void init() {
        this.rf = new RPointFunction("spatialBubblePlot");
        this.rf.setViewType(null);
        ParamSpatialVariable paramSpatialVariable = new ParamSpatialVariable("z");
        paramSpatialVariable.setFormat(ParamSpatialVariable.FORMAT_WITH_DATA_CHARACTER);
        paramSpatialVariable.setTitle("Variable");
        this.rf.add((Param)paramSpatialVariable);
        ParamNumeric paramNumeric = new ParamNumeric("minRadius");
        paramNumeric.setTitle("Minimum size");
        paramNumeric.setDefaultValue(0.01);
        paramNumeric.setLowerBound(0.0);
        paramNumeric.setValue(0.01);
        this.rf.add((Param)paramNumeric);
        paramNumeric = new ParamNumeric("maxRadius");
        paramNumeric.setTitle("Maximum size");
        paramNumeric.setDefaultValue(0.05);
        paramNumeric.setLowerBound(0.0);
        paramNumeric.setValue(0.05);
        this.rf.add((Param)paramNumeric);
        ParamColor paramColor = new ParamColor("color");
        paramColor.setTitle("Color");
        paramColor.setDefaultValue((Object)Color.decode("#F75252"));
        paramColor.setValue((Object)Color.decode("#F75252"));
        paramColor.setRequired(false);
        this.rf.add((Param)paramColor);
        this.iconLocation = "icons/geo_bubble.png";
        this.name = "Bubble";
    }

    public JDialog getView() {
        RFunctionDialog rFunctionDialog = new RFunctionDialog(this.rf);
        rFunctionDialog.setSize(500, 400);
        rFunctionDialog.setRun(false);
        return rFunctionDialog;
    }

    public String getCall() {
        return this.rf.getCall();
    }

    public String checkValid() {
        return this.rf.checkValid();
    }

    public BubbleElementModel clone() {
        BubbleElementModel bubbleElementModel = new BubbleElementModel();
        bubbleElementModel.rf = (RFunction)this.rf.clone();
        return bubbleElementModel;
    }

    public String getDataFrameArgumentName() {
        return ((ParamSpatialVariable)this.rf.get(0)).getData();
    }

    public void setDataFrameArgumentName(String string) {
        ((ParamSpatialVariable)this.rf.get(0)).setData(string);
    }
}

