% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_ensemble.R
\name{complier_mod}
\alias{complier_mod}
\title{Train complier model using ensemble methods}
\usage{
complier_mod(
  exp.data,
  complier.formula,
  treat.var,
  ID = NULL,
  SL.library = c("SL.glmnet", "SL.xgboost", "SL.ranger", "SL.nnet", "SL.glm")
)
}
\arguments{
\item{exp.data}{list object of experimental data.}

\item{complier.formula}{formula to fit compliance model (c ~ x) using
complier variable and covariates}

\item{treat.var}{string specifying the binary treatment variable}

\item{ID}{string for name of indentifier variable.}

\item{SL.library}{vector of strings for ML classifier algorithms. If left
\code{NULL} employs extreme gradient boosting, elastic net regression, random
forest, and neural nets.}
}
\value{
model object of trained model.
}
\description{
Train model using group exposed to treatment with compliance as binary
outcome variable and covariates.
}
