% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_ensemble.R
\name{pattc_ensemble}
\alias{pattc_ensemble}
\title{PATT_C SL Ensemble}
\usage{
pattc_ensemble(
  response.formula,
  exp.data,
  pop.data,
  treat.var,
  compl.var,
  SL.library = c("SL.glmnet", "SL.xgboost", "SL.ranger", "SL.nnet", "SL.glm"),
  ID = NULL,
  cluster = NULL,
  bootse = FALSE,
  bootp = FALSE,
  bootn = 999,
  binary.outcome = TRUE
)
}
\arguments{
\item{response.formula}{formula for the effects of covariates on outcome
variable (y ~ x).}

\item{exp.data}{\code{data.frame} object for experimental data. Must include
binary treatment and compliance variable.}

\item{pop.data}{\code{data.frame} object for population data. Must include
binary compliance variable.}

\item{treat.var}{string for binary treatment variable.}

\item{compl.var}{string for binary compliance variable.}

\item{SL.library}{vector of names of ML algorithms used for ensemble model.}

\item{ID}{string for name of identifier.}

\item{cluster}{string for name of cluster variable.}

\item{bootse}{logical for bootstrapped standard errors.}

\item{bootp}{logical for bootstrapped p values.}

\item{bootn}{number of bootstrap sample.}

\item{binary.outcome}{logical specifying predicted outcome variable will take
binary values or proportions.}
}
\value{
results of t test as PATTC estimate.
}
\description{
\code{pattc_ensemble} estimates the Population Average Treatment Effect
of the Treated from experimental data with noncompliers
using the super learner ensemble that includes extreme gradient boosting,
glmnet (elastic net regression), random forest and neural nets.
}
\examples{
\donttest{
# load datasets
data(exp_data_full) # full experimental data
data(exp_data) #experimental data
data(pop_data) #population data
#attach SuperLearner (model will not recognize learner if package is not loaded)
library(SuperLearner)
set.seed(123456)
#specify models and estimate PATTC
pattc <- pattc_ensemble(response.formula = support_war ~ age + income +
                                education + employed + job_loss,
                                exp.data = exp_data_full,
                                pop.data = pop_data,
                                treat.var = "strong_leader",
                                compl.var = "compliance",
                                SL.library = c("SL.glmnet", "SL.xgboost",
                                                "SL.ranger", "SL.nnet",
                                                "SL.glm"),
                                ID = NULL,
                                cluster = NULL,
                                bootse = FALSE,
                                bootp = FALSE,
                                bootn = 999,
                                binary.outcome = TRUE)
summary(pattc)
}

}
